/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.uninverting;

import java.io.IOException;
import java.io.PrintStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.BinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.uninverting.FieldCacheImpl;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Accountable;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.LegacyNumericUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.NumericUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.RamUsageEstimator;

interface FieldCache {
    public static final FieldCache DEFAULT = new FieldCacheImpl();
    public static final Parser INT_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableBytesToInt(point.bytes, point.offset);
        }

        public String toString() {
            return FieldCache.class.getName() + ".INT_POINT_PARSER";
        }
    };
    public static final Parser LONG_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableBytesToLong(point.bytes, point.offset);
        }

        public String toString() {
            return FieldCache.class.getName() + ".LONG_POINT_PARSER";
        }
    };
    public static final Parser FLOAT_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableFloatBits(NumericUtils.sortableBytesToInt(point.bytes, point.offset));
        }

        public String toString() {
            return FieldCache.class.getName() + ".FLOAT_POINT_PARSER";
        }
    };
    public static final Parser DOUBLE_POINT_PARSER = new PointParser(){

        @Override
        public long parseValue(BytesRef point) {
            return NumericUtils.sortableDoubleBits(NumericUtils.sortableBytesToLong(point.bytes, point.offset));
        }

        public String toString() {
            return FieldCache.class.getName() + ".DOUBLE_POINT_PARSER";
        }
    };
    @Deprecated
    public static final Parser LEGACY_INT_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            return LegacyNumericUtils.prefixCodedToInt(term);
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedInts(terms.iterator());
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_INT_PARSER";
        }
    };
    @Deprecated
    public static final Parser LEGACY_FLOAT_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            int val = LegacyNumericUtils.prefixCodedToInt(term);
            if (val < 0) {
                val ^= Integer.MAX_VALUE;
            }
            return val;
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_FLOAT_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedInts(terms.iterator());
        }
    };
    @Deprecated
    public static final Parser LEGACY_LONG_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            return LegacyNumericUtils.prefixCodedToLong(term);
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_LONG_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedLongs(terms.iterator());
        }
    };
    @Deprecated
    public static final Parser LEGACY_DOUBLE_PARSER = new Parser(){

        @Override
        public long parseValue(BytesRef term) {
            long val = LegacyNumericUtils.prefixCodedToLong(term);
            if (val < 0L) {
                val ^= Long.MAX_VALUE;
            }
            return val;
        }

        public String toString() {
            return FieldCache.class.getName() + ".LEGACY_DOUBLE_PARSER";
        }

        @Override
        public TermsEnum termsEnum(Terms terms) throws IOException {
            return LegacyNumericUtils.filterPrefixCodedLongs(terms.iterator());
        }
    };
    public static final BytesRef INT32_TERM_PREFIX = new BytesRef(new byte[]{96});
    public static final BytesRef INT64_TERM_PREFIX = new BytesRef(new byte[]{32});

    public Bits getDocsWithField(LeafReader var1, String var2, Parser var3) throws IOException;

    public NumericDocValues getNumerics(LeafReader var1, String var2, Parser var3, boolean var4) throws IOException;

    public BinaryDocValues getTerms(LeafReader var1, String var2, boolean var3) throws IOException;

    public BinaryDocValues getTerms(LeafReader var1, String var2, boolean var3, float var4) throws IOException;

    public SortedDocValues getTermsIndex(LeafReader var1, String var2) throws IOException;

    public SortedDocValues getTermsIndex(LeafReader var1, String var2, float var3) throws IOException;

    public SortedSetDocValues getDocTermOrds(LeafReader var1, String var2, BytesRef var3) throws IOException;

    public CacheEntry[] getCacheEntries();

    public void purgeAllCaches();

    public void purgeByCacheKey(Object var1);

    public void setInfoStream(PrintStream var1);

    public PrintStream getInfoStream();

    public static final class CacheEntry {
        private final Object readerKey;
        private final String fieldName;
        private final Class<?> cacheType;
        private final Object custom;
        private final Accountable value;

        public CacheEntry(Object readerKey, String fieldName, Class<?> cacheType, Object custom, Accountable value) {
            this.readerKey = readerKey;
            this.fieldName = fieldName;
            this.cacheType = cacheType;
            this.custom = custom;
            this.value = value;
        }

        public Object getReaderKey() {
            return this.readerKey;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Class<?> getCacheType() {
            return this.cacheType;
        }

        public Object getCustom() {
            return this.custom;
        }

        public Object getValue() {
            return this.value;
        }

        public String getEstimatedSize() {
            long bytesUsed = this.value == null ? 0L : this.value.ramBytesUsed();
            return RamUsageEstimator.humanReadableUnits(bytesUsed);
        }

        public String toString() {
            StringBuilder b = new StringBuilder(250);
            b.append("'").append(this.getReaderKey()).append("'=>");
            b.append("'").append(this.getFieldName()).append("',");
            b.append(this.getCacheType()).append(",").append(this.getCustom());
            b.append("=>").append(this.getValue().getClass().getName()).append("#");
            b.append(System.identityHashCode(this.getValue()));
            String s = this.getEstimatedSize();
            b.append(" (size =~ ").append(s).append(')');
            return b.toString();
        }
    }

    public static abstract class PointParser
    implements Parser {
        @Override
        public final TermsEnum termsEnum(Terms terms) throws IOException {
            throw new UnsupportedOperationException("makes no sense for parsing points");
        }
    }

    public static interface Parser {
        @Deprecated
        public TermsEnum termsEnum(Terms var1) throws IOException;

        public long parseValue(BytesRef var1);
    }

    public static final class CreationPlaceholder
    implements Accountable {
        Accountable value;

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        }
    }
}

