/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.health.ClusterStateHealth;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;

public class ClusterHealthResponse
extends ActionResponse
implements StatusToXContentObject {
    private String clusterName;
    private int numberOfPendingTasks = 0;
    private int numberOfInFlightFetch = 0;
    private int delayedUnassignedShards = 0;
    private TimeValue taskMaxWaitingTime = TimeValue.timeValueMillis(0L);
    private boolean timedOut = false;
    private ClusterStateHealth clusterStateHealth;
    private ClusterHealthStatus clusterHealthStatus;
    private static final String CLUSTER_NAME = "cluster_name";
    private static final String STATUS = "status";
    private static final String TIMED_OUT = "timed_out";
    private static final String NUMBER_OF_NODES = "number_of_nodes";
    private static final String NUMBER_OF_DATA_NODES = "number_of_data_nodes";
    private static final String NUMBER_OF_PENDING_TASKS = "number_of_pending_tasks";
    private static final String NUMBER_OF_IN_FLIGHT_FETCH = "number_of_in_flight_fetch";
    private static final String DELAYED_UNASSIGNED_SHARDS = "delayed_unassigned_shards";
    private static final String TASK_MAX_WAIT_TIME_IN_QUEUE = "task_max_waiting_in_queue";
    private static final String TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS = "task_max_waiting_in_queue_millis";
    private static final String ACTIVE_SHARDS_PERCENT_AS_NUMBER = "active_shards_percent_as_number";
    private static final String ACTIVE_SHARDS_PERCENT = "active_shards_percent";
    private static final String ACTIVE_PRIMARY_SHARDS = "active_primary_shards";
    private static final String ACTIVE_SHARDS = "active_shards";
    private static final String RELOCATING_SHARDS = "relocating_shards";
    private static final String INITIALIZING_SHARDS = "initializing_shards";
    private static final String UNASSIGNED_SHARDS = "unassigned_shards";
    private static final String INDICES = "indices";

    ClusterHealthResponse() {
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState) {
        this(clusterName, concreteIndices, clusterState, -1, -1, -1, TimeValue.timeValueHours(0L));
    }

    public ClusterHealthResponse(String clusterName, String[] concreteIndices, ClusterState clusterState, int numberOfPendingTasks, int numberOfInFlightFetch, int delayedUnassignedShards, TimeValue taskMaxWaitingTime) {
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.clusterName = clusterName;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.taskMaxWaitingTime = taskMaxWaitingTime;
        this.clusterStateHealth = new ClusterStateHealth(clusterState, concreteIndices);
        this.clusterHealthStatus = this.clusterStateHealth.getStatus();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    ClusterStateHealth getClusterStateHealth() {
        return this.clusterStateHealth;
    }

    public int getActiveShards() {
        return this.clusterStateHealth.getActiveShards();
    }

    public int getRelocatingShards() {
        return this.clusterStateHealth.getRelocatingShards();
    }

    public int getActivePrimaryShards() {
        return this.clusterStateHealth.getActivePrimaryShards();
    }

    public int getInitializingShards() {
        return this.clusterStateHealth.getInitializingShards();
    }

    public int getUnassignedShards() {
        return this.clusterStateHealth.getUnassignedShards();
    }

    public int getNumberOfNodes() {
        return this.clusterStateHealth.getNumberOfNodes();
    }

    public int getNumberOfDataNodes() {
        return this.clusterStateHealth.getNumberOfDataNodes();
    }

    public int getNumberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public int getNumberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    public ClusterHealthStatus getStatus() {
        return this.clusterHealthStatus;
    }

    public void setStatus(ClusterHealthStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("'status' must not be null");
        }
        this.clusterHealthStatus = status;
    }

    public Map<String, ClusterIndexHealth> getIndices() {
        return this.clusterStateHealth.getIndices();
    }

    public TimeValue getTaskMaxWaitingTime() {
        return this.taskMaxWaitingTime;
    }

    public double getActiveShardsPercent() {
        return this.clusterStateHealth.getActiveShardsPercent();
    }

    public static ClusterHealthResponse readResponseFrom(StreamInput in) throws IOException {
        ClusterHealthResponse response = new ClusterHealthResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = in.readString();
        this.clusterHealthStatus = ClusterHealthStatus.fromValue(in.readByte());
        this.clusterStateHealth = new ClusterStateHealth(in);
        this.numberOfPendingTasks = in.readInt();
        this.timedOut = in.readBoolean();
        this.numberOfInFlightFetch = in.readInt();
        this.delayedUnassignedShards = in.readInt();
        this.taskMaxWaitingTime = new TimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterName);
        out.writeByte(this.clusterHealthStatus.value());
        this.clusterStateHealth.writeTo(out);
        out.writeInt(this.numberOfPendingTasks);
        out.writeBoolean(this.timedOut);
        out.writeInt(this.numberOfInFlightFetch);
        out.writeInt(this.delayedUnassignedShards);
        this.taskMaxWaitingTime.writeTo(out);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public RestStatus status() {
        return this.isTimedOut() ? RestStatus.REQUEST_TIMEOUT : RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean outputIndices;
        builder.startObject();
        builder.field(CLUSTER_NAME, this.getClusterName());
        builder.field(STATUS, this.getStatus().name().toLowerCase(Locale.ROOT));
        builder.field(TIMED_OUT, this.isTimedOut());
        builder.field(NUMBER_OF_NODES, this.getNumberOfNodes());
        builder.field(NUMBER_OF_DATA_NODES, this.getNumberOfDataNodes());
        builder.field(ACTIVE_PRIMARY_SHARDS, this.getActivePrimaryShards());
        builder.field(ACTIVE_SHARDS, this.getActiveShards());
        builder.field(RELOCATING_SHARDS, this.getRelocatingShards());
        builder.field(INITIALIZING_SHARDS, this.getInitializingShards());
        builder.field(UNASSIGNED_SHARDS, this.getUnassignedShards());
        builder.field(DELAYED_UNASSIGNED_SHARDS, this.getDelayedUnassignedShards());
        builder.field(NUMBER_OF_PENDING_TASKS, this.getNumberOfPendingTasks());
        builder.field(NUMBER_OF_IN_FLIGHT_FETCH, this.getNumberOfInFlightFetch());
        builder.timeValueField(TASK_MAX_WAIT_TIME_IN_QUEUE_IN_MILLIS, TASK_MAX_WAIT_TIME_IN_QUEUE, this.getTaskMaxWaitingTime());
        builder.percentageField(ACTIVE_SHARDS_PERCENT_AS_NUMBER, ACTIVE_SHARDS_PERCENT, this.getActiveShardsPercent());
        String level = params.param("level", "cluster");
        boolean bl = outputIndices = INDICES.equals(level) || "shards".equals(level);
        if (outputIndices) {
            builder.startObject(INDICES);
            for (ClusterIndexHealth indexHealth : this.clusterStateHealth.getIndices().values()) {
                builder.startObject(indexHealth.getIndex());
                indexHealth.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

