/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.cluster.snapshots.create;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchGenerationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.support.XContentMapValues;

public class CreateSnapshotRequest
extends MasterNodeRequest<CreateSnapshotRequest>
implements IndicesRequest.Replaceable {
    private String snapshot;
    private String repository;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private boolean partial = false;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private boolean includeGlobalState = true;
    private boolean waitForCompletion;

    public CreateSnapshotRequest() {
    }

    public CreateSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.snapshot == null) {
            validationException = ValidateActions.addValidationError("snapshot is missing", validationException);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices is null", validationException);
        } else {
            for (String index : this.indices) {
                if (index != null) continue;
                validationException = ValidateActions.addValidationError("index is null", validationException);
                break;
            }
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError("indicesOptions is null", validationException);
        }
        if (this.settings == null) {
            validationException = ValidateActions.addValidationError("settings is null", validationException);
        }
        return validationException;
    }

    public CreateSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public CreateSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    @Override
    public CreateSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public CreateSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[indices.size()]);
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public CreateSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public boolean partial() {
        return this.partial;
    }

    public CreateSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public CreateSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public CreateSnapshotRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateSnapshotRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    @Deprecated
    public CreateSnapshotRequest settings(String source) {
        this.settings = Settings.builder().loadFromSource(source).build();
        return this;
    }

    public CreateSnapshotRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CreateSnapshotRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string(), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public CreateSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public CreateSnapshotRequest source(Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("indices")) {
                if (entry.getValue() instanceof String) {
                    this.indices(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof ArrayList) {
                    this.indices((ArrayList)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed indices section, should be an array of strings");
            }
            if (name.equals("partial")) {
                this.partial(XContentMapValues.lenientNodeBooleanValue(entry.getValue(), name));
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed settings section, should indices an inner object");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (!name.equals("include_global_state")) continue;
            this.includeGlobalState = XContentMapValues.lenientNodeBooleanValue(entry.getValue(), name);
        }
        this.indicesOptions(IndicesOptions.fromMap(source, IndicesOptions.lenientExpandOpen()));
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.settings = Settings.readSettingsFromStream(in);
        this.includeGlobalState = in.readBoolean();
        this.waitForCompletion = in.readBoolean();
        this.partial = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeBoolean(this.includeGlobalState);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.partial);
    }

    @Override
    public String getDescription() {
        return "snapshot [" + this.repository + ":" + this.snapshot + "]";
    }
}

