/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.get;

import java.util.List;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.master.info.TransportClusterInfoAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.AliasMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MappingMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportGetIndexAction
extends TransportClusterInfoAction<GetIndexRequest, GetIndexResponse> {
    @Inject
    public TransportGetIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:admin/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetIndexRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(GetIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected GetIndexResponse newResponse() {
        return new GetIndexResponse();
    }

    @Override
    protected void doMasterOperation(GetIndexRequest request, String[] concreteIndices, ClusterState state, ActionListener<GetIndexResponse> listener) {
        ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetaData>> mappingsResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, List<AliasMetaData>> aliasesResult = ImmutableOpenMap.of();
        ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
        GetIndexRequest.Feature[] features = request.features();
        boolean doneAliases = false;
        boolean doneMappings = false;
        boolean doneSettings = false;
        block5: for (GetIndexRequest.Feature feature : features) {
            switch (feature) {
                case MAPPINGS: {
                    if (doneMappings) continue block5;
                    mappingsResult = state.metaData().findMappings(concreteIndices, request.types());
                    doneMappings = true;
                    continue block5;
                }
                case ALIASES: {
                    if (doneAliases) continue block5;
                    aliasesResult = state.metaData().findAliases(Strings.EMPTY_ARRAY, concreteIndices);
                    doneAliases = true;
                    continue block5;
                }
                case SETTINGS: {
                    if (doneSettings) continue block5;
                    ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
                    for (String index : concreteIndices) {
                        Settings indexSettings = state.metaData().index(index).getSettings();
                        if (request.humanReadable()) {
                            indexSettings = IndexMetaData.addHumanReadableSettings(indexSettings);
                        }
                        settingsMapBuilder.put(index, indexSettings);
                    }
                    settings = settingsMapBuilder.build();
                    doneSettings = true;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("feature [" + (Object)((Object)feature) + "] is not valid");
                }
            }
        }
        listener.onResponse(new GetIndexResponse(concreteIndices, mappingsResult, aliasesResult, settings));
    }
}

