/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardsIterator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.collect.MapBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.regex.Regex;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentFactory;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentType;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.DocumentMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.TypeMissingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class TransportGetFieldMappingsIndexAction
extends TransportSingleShardAction<GetFieldMappingsIndexRequest, GetFieldMappingsResponse> {
    private static final String ACTION_NAME = "indices:admin/mappings/fields/get[index]";
    protected final ClusterService clusterService;
    private final IndicesService indicesService;
    private static final ToXContent.Params includeDefaultsParams = new ToXContent.Params(){
        static final String INCLUDE_DEFAULTS = "include_defaults";

        @Override
        public String param(String key) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }
    };

    @Inject
    public TransportGetFieldMappingsIndexAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetFieldMappingsIndexRequest::new, "management");
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(GetFieldMappingsIndexRequest request) {
        return false;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected GetFieldMappingsResponse shardOperation(GetFieldMappingsIndexRequest request, ShardId shardId) {
        Collection typeIntersection;
        assert (shardId != null);
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        if (request.types().length == 0) {
            typeIntersection = indexService.mapperService().types();
        } else {
            typeIntersection = indexService.mapperService().types().stream().filter(type -> Regex.simpleMatch(request.types(), type)).collect(Collectors.toCollection(ArrayList::new));
            if (typeIntersection.isEmpty()) {
                throw new TypeMissingException(shardId.getIndex(), request.types());
            }
        }
        MapBuilder<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>> typeMappings = new MapBuilder<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>();
        for (String type2 : typeIntersection) {
            DocumentMapper documentMapper = indexService.mapperService().documentMapper(type2);
            Map<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMapping = this.findFieldMappingsByType(documentMapper, request);
            if (fieldMapping.isEmpty()) continue;
            typeMappings.put(type2, fieldMapping);
        }
        return new GetFieldMappingsResponse(Collections.singletonMap(shardId.getIndexName(), typeMappings.immutableMap()));
    }

    @Override
    protected GetFieldMappingsResponse newResponse() {
        return new GetFieldMappingsResponse();
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_READ, request.concreteIndex());
    }

    private Map<String, GetFieldMappingsResponse.FieldMappingMetaData> findFieldMappingsByType(DocumentMapper documentMapper, GetFieldMappingsIndexRequest request) {
        MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings = new MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData>();
        DocumentFieldMappers allFieldMappers = documentMapper.mappers();
        for (String field : request.fields()) {
            if (Regex.isMatchAllPattern(field)) {
                for (FieldMapper fieldMapper : allFieldMappers) {
                    this.addFieldMapper(fieldMapper.fieldType().name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            if (Regex.isSimpleMatchPattern(field)) {
                for (FieldMapper fieldMapper : allFieldMappers) {
                    if (!Regex.simpleMatch(field, fieldMapper.fieldType().name())) continue;
                    this.addFieldMapper(fieldMapper.fieldType().name(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            FieldMapper fieldMapper = allFieldMappers.smartNameFieldMapper(field);
            if (fieldMapper != null) {
                this.addFieldMapper(field, fieldMapper, fieldMappings, request.includeDefaults());
                continue;
            }
            if (!request.probablySingleFieldRequest()) continue;
            fieldMappings.put(field, GetFieldMappingsResponse.FieldMappingMetaData.NULL);
        }
        return fieldMappings.immutableMap();
    }

    private void addFieldMapper(String field, FieldMapper fieldMapper, MapBuilder<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappings, boolean includeDefaults) {
        if (fieldMappings.containsKey(field)) {
            return;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            fieldMapper.toXContent(builder, includeDefaults ? includeDefaultsParams : ToXContent.EMPTY_PARAMS);
            builder.endObject();
            fieldMappings.put(field, new GetFieldMappingsResponse.FieldMappingMetaData(fieldMapper.fieldType().name(), builder.bytes()));
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to serialize XContent of field [" + field + "]", (Throwable)e, new Object[0]);
        }
    }
}

