/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.upgrade.get;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;

public class ShardUpgradeStatus
extends BroadcastShardResponse {
    private ShardRouting shardRouting;
    private long totalBytes;
    private long toUpgradeBytes;
    private long toUpgradeBytesAncient;

    ShardUpgradeStatus() {
    }

    ShardUpgradeStatus(ShardRouting shardRouting, long totalBytes, long toUpgradeBytes, long upgradeBytesAncient) {
        super(shardRouting.shardId());
        this.shardRouting = shardRouting;
        this.totalBytes = totalBytes;
        this.toUpgradeBytes = toUpgradeBytes;
        this.toUpgradeBytesAncient = upgradeBytesAncient;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getToUpgradeBytes() {
        return this.toUpgradeBytes;
    }

    public long getToUpgradeBytesAncient() {
        return this.toUpgradeBytesAncient;
    }

    public static ShardUpgradeStatus readShardUpgradeStatus(StreamInput in) throws IOException {
        ShardUpgradeStatus shard = new ShardUpgradeStatus();
        shard.readFrom(in);
        return shard;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardRouting = new ShardRouting(in);
        this.totalBytes = in.readLong();
        this.toUpgradeBytes = in.readLong();
        this.toUpgradeBytesAncient = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardRouting.writeTo(out);
        out.writeLong(this.totalBytes);
        out.writeLong(this.toUpgradeBytes);
        out.writeLong(this.toUpgradeBytesAncient);
    }
}

