/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ShardOperationFailedException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;

public class DefaultShardOperationFailedException
implements ShardOperationFailedException {
    private String index;
    private int shardId;
    private Throwable reason;
    private RestStatus status;

    protected DefaultShardOperationFailedException() {
    }

    public DefaultShardOperationFailedException(ElasticsearchException e) {
        this.index = e.getIndex() == null ? null : e.getIndex().getName();
        this.shardId = e.getShardId().id();
        this.reason = e;
        this.status = e.status();
    }

    public DefaultShardOperationFailedException(String index, int shardId, Throwable reason) {
        this.index = index;
        this.shardId = shardId;
        this.reason = reason;
        this.status = ExceptionsHelper.status(reason);
    }

    @Override
    public String index() {
        return this.index;
    }

    @Override
    public int shardId() {
        return this.shardId;
    }

    @Override
    public String reason() {
        return ExceptionsHelper.detailedMessage(this.reason);
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public Throwable getCause() {
        return this.reason;
    }

    public static DefaultShardOperationFailedException readShardOperationFailed(StreamInput in) throws IOException {
        DefaultShardOperationFailedException exp = new DefaultShardOperationFailedException();
        exp.readFrom(in);
        return exp;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.index = in.readString();
        }
        this.shardId = in.readVInt();
        this.reason = in.readException();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.index == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeString(this.index);
        }
        out.writeVInt(this.shardId);
        out.writeException(this.reason);
        RestStatus.writeTo(out, this.status);
    }

    public String toString() {
        return "[" + this.index + "][" + this.shardId + "] failed, reason [" + this.reason() + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("shard", this.shardId());
        builder.field("index", this.index());
        builder.field("status", this.status.name());
        if (this.reason != null) {
            builder.field("reason");
            builder.startObject();
            ElasticsearchException.generateThrowableXContent(builder, params, this.reason);
            builder.endObject();
        }
        return builder;
    }
}

