/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cli;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.joptsimple.NonOptionArgumentSpec;
import org.graylog.shaded.elasticsearch5.joptsimple.OptionSet;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Command;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.Terminal;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cli.UserException;

public class MultiCommand
extends Command {
    protected final Map<String, Command> subcommands = new LinkedHashMap<String, Command>();
    private final NonOptionArgumentSpec<String> arguments = this.parser.nonOptions("command");

    public MultiCommand(String description) {
        super(description);
        this.parser.posixlyCorrect(true);
    }

    @Override
    protected void printAdditionalHelp(Terminal terminal) {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        terminal.println("Commands");
        terminal.println("--------");
        for (Map.Entry<String, Command> subcommand : this.subcommands.entrySet()) {
            terminal.println(subcommand.getKey() + " - " + subcommand.getValue().description);
        }
        terminal.println("");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options) throws Exception {
        if (this.subcommands.isEmpty()) {
            throw new IllegalStateException("No subcommands configured");
        }
        String[] args = this.arguments.values(options).toArray(new String[0]);
        if (args.length == 0) {
            throw new UserException(64, "Missing command");
        }
        Command subcommand = this.subcommands.get(args[0]);
        if (subcommand == null) {
            throw new UserException(64, "Unknown command [" + args[0] + "]");
        }
        subcommand.mainWithoutErrorHandling(Arrays.copyOfRange(args, 1, args.length), terminal);
    }
}

