/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.ClusterState;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.NamedDiff;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.NodeConnectionsService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.RestoreInProgress;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.SnapshotsInProgress;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.action.index.NodeMappingRefreshAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataDeleteIndexService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.MetaDataUpdateSettingsService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.DelayedAllocationService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RoutingService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.AwarenessAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.ConcurrentRebalanceAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.DiskThresholdDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.EnableAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.FilterAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.MaxRetryAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.NodeVersionAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.RebalanceOnlyWhenActiveAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.ReplicaAfterPrimaryActiveAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.RestoreInProgressAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.SameShardAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.SnapshotInProgressAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.allocation.decider.ThrottlingAllocationDecider;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.AbstractModule;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.ClusterSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.gateway.GatewayAllocator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestMetadata;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.ClusterPlugin;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptMetaData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.tasks.TaskResultsService;

public class ClusterModule
extends AbstractModule {
    public static final String BALANCED_ALLOCATOR = "balanced";
    public static final Setting<String> SHARDS_ALLOCATOR_TYPE_SETTING = new Setting("cluster.routing.allocation.type", "balanced", Function.identity(), Setting.Property.NodeScope);
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    final Collection<AllocationDecider> allocationDeciders;
    final ShardsAllocator shardsAllocator;

    public ClusterModule(Settings settings, ClusterService clusterService, List<ClusterPlugin> clusterPlugins) {
        this.settings = settings;
        this.allocationDeciders = ClusterModule.createAllocationDeciders(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.shardsAllocator = ClusterModule.createShardsAllocator(settings, clusterService.getClusterSettings(), clusterPlugins);
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = new IndexNameExpressionResolver(settings);
    }

    public static List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        ClusterModule.registerClusterCustom(entries, "snapshots", SnapshotsInProgress::new, SnapshotsInProgress::readDiffFrom);
        ClusterModule.registerClusterCustom(entries, "restore", RestoreInProgress::new, RestoreInProgress::readDiffFrom);
        ClusterModule.registerClusterCustom(entries, "snapshot_deletions", SnapshotDeletionsInProgress::new, SnapshotDeletionsInProgress::readDiffFrom);
        ClusterModule.registerMetaDataCustom(entries, "repositories", RepositoriesMetaData::new, RepositoriesMetaData::readDiffFrom);
        ClusterModule.registerMetaDataCustom(entries, "ingest", IngestMetadata::new, IngestMetadata::readDiffFrom);
        ClusterModule.registerMetaDataCustom(entries, "stored_scripts", ScriptMetaData::new, ScriptMetaData::readDiffFrom);
        ClusterModule.registerMetaDataCustom(entries, "index-graveyard", IndexGraveyard::new, IndexGraveyard::readDiffFrom);
        return entries;
    }

    public static List<NamedXContentRegistry.Entry> getNamedXWriteables() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("repositories", new String[0]), RepositoriesMetaData::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("ingest", new String[0]), IngestMetadata::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("stored_scripts", new String[0]), ScriptMetaData::fromXContent));
        entries.add(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("index-graveyard", new String[0]), IndexGraveyard::fromXContent));
        return entries;
    }

    private static <T extends ClusterState.Custom> void registerClusterCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, ClusterState.Custom.class, name, reader, diffReader);
    }

    private static <T extends MetaData.Custom> void registerMetaDataCustom(List<NamedWriteableRegistry.Entry> entries, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        ClusterModule.registerCustom(entries, MetaData.Custom.class, name, reader, diffReader);
    }

    private static <T extends NamedWriteable> void registerCustom(List<NamedWriteableRegistry.Entry> entries, Class<T> category, String name, Writeable.Reader<? extends T> reader, Writeable.Reader<NamedDiff> diffReader) {
        entries.add(new NamedWriteableRegistry.Entry(category, name, reader));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, name, diffReader));
    }

    public IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    public static Collection<AllocationDecider> createAllocationDeciders(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        LinkedHashMap<Class, AllocationDecider> deciders = new LinkedHashMap<Class, AllocationDecider>();
        ClusterModule.addAllocationDecider(deciders, new MaxRetryAllocationDecider(settings));
        ClusterModule.addAllocationDecider(deciders, new ReplicaAfterPrimaryActiveAllocationDecider(settings));
        ClusterModule.addAllocationDecider(deciders, new RebalanceOnlyWhenActiveAllocationDecider(settings));
        ClusterModule.addAllocationDecider(deciders, new ClusterRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ConcurrentRebalanceAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new EnableAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new NodeVersionAllocationDecider(settings));
        ClusterModule.addAllocationDecider(deciders, new SnapshotInProgressAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new RestoreInProgressAllocationDecider(settings));
        ClusterModule.addAllocationDecider(deciders, new FilterAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new SameShardAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new DiskThresholdDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ThrottlingAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new ShardsLimitAllocationDecider(settings, clusterSettings));
        ClusterModule.addAllocationDecider(deciders, new AwarenessAllocationDecider(settings, clusterSettings));
        clusterPlugins.stream().flatMap(p -> p.createAllocationDeciders(settings, clusterSettings).stream()).forEach(d -> ClusterModule.addAllocationDecider(deciders, d));
        return deciders.values();
    }

    private static void addAllocationDecider(Map<Class, AllocationDecider> deciders, AllocationDecider decider) {
        if (deciders.put(decider.getClass(), decider) != null) {
            throw new IllegalArgumentException("Cannot specify allocation decider [" + decider.getClass().getName() + "] twice");
        }
    }

    private static ShardsAllocator createShardsAllocator(Settings settings, ClusterSettings clusterSettings, List<ClusterPlugin> clusterPlugins) {
        HashMap<String, Supplier<ShardsAllocator>> allocators = new HashMap<String, Supplier<ShardsAllocator>>();
        allocators.put(BALANCED_ALLOCATOR, () -> new BalancedShardsAllocator(settings, clusterSettings));
        for (ClusterPlugin plugin : clusterPlugins) {
            plugin.getShardsAllocators(settings, clusterSettings).forEach((k, v) -> {
                if (allocators.put((String)k, (Supplier<ShardsAllocator>)v) != null) {
                    throw new IllegalArgumentException("ShardsAllocator [" + k + "] already defined");
                }
            });
        }
        String allocatorName = SHARDS_ALLOCATOR_TYPE_SETTING.get(settings);
        Supplier allocatorSupplier = (Supplier)allocators.get(allocatorName);
        if (allocatorSupplier == null) {
            throw new IllegalArgumentException("Unknown ShardsAllocator [" + allocatorName + "]");
        }
        return (ShardsAllocator)Objects.requireNonNull(allocatorSupplier.get(), "ShardsAllocator factory for [" + allocatorName + "] returned null");
    }

    @Override
    protected void configure() {
        this.bind(GatewayAllocator.class).asEagerSingleton();
        this.bind(AllocationService.class).asEagerSingleton();
        this.bind(ClusterService.class).toInstance(this.clusterService);
        this.bind(NodeConnectionsService.class).asEagerSingleton();
        this.bind(MetaDataCreateIndexService.class).asEagerSingleton();
        this.bind(MetaDataDeleteIndexService.class).asEagerSingleton();
        this.bind(MetaDataIndexStateService.class).asEagerSingleton();
        this.bind(MetaDataMappingService.class).asEagerSingleton();
        this.bind(MetaDataIndexAliasesService.class).asEagerSingleton();
        this.bind(MetaDataUpdateSettingsService.class).asEagerSingleton();
        this.bind(MetaDataIndexTemplateService.class).asEagerSingleton();
        this.bind(IndexNameExpressionResolver.class).toInstance(this.indexNameExpressionResolver);
        this.bind(RoutingService.class).asEagerSingleton();
        this.bind(DelayedAllocationService.class).asEagerSingleton();
        this.bind(ShardStateAction.class).asEagerSingleton();
        this.bind(NodeMappingRefreshAction.class).asEagerSingleton();
        this.bind(MappingUpdatedAction.class).asEagerSingleton();
        this.bind(TaskResultsService.class).asEagerSingleton();
        this.bind(AllocationDeciders.class).toInstance(new AllocationDeciders(this.settings, this.allocationDeciders));
        this.bind(ShardsAllocator.class).toInstance(this.shardsAllocator);
    }
}

