/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.health;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RecoverySource;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.UnassignedInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;

public final class ClusterShardHealth
implements Writeable {
    private final int shardId;
    private final ClusterHealthStatus status;
    private final int activeShards;
    private final int relocatingShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final boolean primaryActive;

    public ClusterShardHealth(int shardId, IndexShardRoutingTable shardRoutingTable) {
        this.shardId = shardId;
        int computeActiveShards = 0;
        int computeRelocatingShards = 0;
        int computeInitializingShards = 0;
        int computeUnassignedShards = 0;
        for (ShardRouting shardRouting : shardRoutingTable) {
            if (shardRouting.active()) {
                ++computeActiveShards;
                if (!shardRouting.relocating()) continue;
                ++computeRelocatingShards;
                continue;
            }
            if (shardRouting.initializing()) {
                ++computeInitializingShards;
                continue;
            }
            if (!shardRouting.unassigned()) continue;
            ++computeUnassignedShards;
        }
        ShardRouting primaryRouting = shardRoutingTable.primaryShard();
        ClusterHealthStatus computeStatus = primaryRouting.active() ? (computeActiveShards == shardRoutingTable.size() ? ClusterHealthStatus.GREEN : ClusterHealthStatus.YELLOW) : ClusterShardHealth.getInactivePrimaryHealth(primaryRouting);
        this.status = computeStatus;
        this.activeShards = computeActiveShards;
        this.relocatingShards = computeRelocatingShards;
        this.initializingShards = computeInitializingShards;
        this.unassignedShards = computeUnassignedShards;
        this.primaryActive = primaryRouting.active();
    }

    public ClusterShardHealth(StreamInput in) throws IOException {
        this.shardId = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.primaryActive = in.readBoolean();
    }

    public int getId() {
        return this.shardId;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public boolean isPrimaryActive() {
        return this.primaryActive;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardId);
        out.writeByte(this.status.value());
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeBoolean(this.primaryActive);
    }

    public static ClusterHealthStatus getInactivePrimaryHealth(ShardRouting shardRouting) {
        assert (shardRouting.primary()) : "cannot invoke on a replica shard: " + shardRouting;
        assert (!shardRouting.active()) : "cannot invoke on an active shard: " + shardRouting;
        assert (shardRouting.unassignedInfo() != null) : "cannot invoke on a shard with no UnassignedInfo: " + shardRouting;
        assert (shardRouting.recoverySource() != null) : "cannot invoke on a shard that has no recovery source" + shardRouting;
        UnassignedInfo unassignedInfo = shardRouting.unassignedInfo();
        RecoverySource.Type recoveryType = shardRouting.recoverySource().getType();
        if (unassignedInfo.getLastAllocationStatus() != UnassignedInfo.AllocationStatus.DECIDERS_NO && unassignedInfo.getNumFailedAllocations() == 0 && (recoveryType == RecoverySource.Type.EMPTY_STORE || recoveryType == RecoverySource.Type.LOCAL_SHARDS || recoveryType == RecoverySource.Type.SNAPSHOT)) {
            return ClusterHealthStatus.YELLOW;
        }
        return ClusterHealthStatus.RED;
    }
}

