/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.UUIDs;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;

public class AllocationId
implements ToXContent,
Writeable {
    private static final String ID_KEY = "id";
    private static final String RELOCATION_ID_KEY = "relocation_id";
    private static final ObjectParser<Builder, Void> ALLOCATION_ID_PARSER = new ObjectParser("allocationId");
    private final String id;
    @Nullable
    private final String relocationId;

    AllocationId(StreamInput in) throws IOException {
        this.id = in.readString();
        this.relocationId = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeOptionalString(this.relocationId);
    }

    private AllocationId(String id, String relocationId) {
        Objects.requireNonNull(id, "Argument [id] must be non-null");
        this.id = id;
        this.relocationId = relocationId;
    }

    public static AllocationId newInitializing() {
        return new AllocationId(UUIDs.randomBase64UUID(), null);
    }

    public static AllocationId newInitializing(String existingAllocationId) {
        return new AllocationId(existingAllocationId, null);
    }

    public static AllocationId newTargetRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() != null);
        return new AllocationId(allocationId.getRelocationId(), allocationId.getId());
    }

    public static AllocationId newRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() == null);
        return new AllocationId(allocationId.getId(), UUIDs.randomBase64UUID());
    }

    public static AllocationId cancelRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() != null);
        return new AllocationId(allocationId.getId(), null);
    }

    public static AllocationId finishRelocation(AllocationId allocationId) {
        assert (allocationId.getRelocationId() != null);
        return new AllocationId(allocationId.getId(), null);
    }

    public String getId() {
        return this.id;
    }

    public String getRelocationId() {
        return this.relocationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        AllocationId that = (AllocationId)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return !(this.relocationId == null ? that.relocationId != null : !this.relocationId.equals(that.relocationId));
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.relocationId != null ? this.relocationId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "[id=" + this.id + (this.relocationId == null ? "" : ", rId=" + this.relocationId) + "]";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID_KEY, this.id);
        if (this.relocationId != null) {
            builder.field(RELOCATION_ID_KEY, this.relocationId);
        }
        builder.endObject();
        return builder;
    }

    public static AllocationId fromXContent(XContentParser parser) throws IOException {
        return ALLOCATION_ID_PARSER.parse(parser, new Builder(), null).build();
    }

    static {
        ALLOCATION_ID_PARSER.declareString(Builder::setId, new ParseField(ID_KEY, new String[0]));
        ALLOCATION_ID_PARSER.declareString(Builder::setRelocationId, new ParseField(RELOCATION_ID_KEY, new String[0]));
    }

    private static class Builder {
        private String id;
        private String relocationId;

        private Builder() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setRelocationId(String relocationId) {
            this.relocationId = relocationId;
        }

        public AllocationId build() {
            return new AllocationId(this.id, this.relocationId);
        }
    }
}

