/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.loader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;

public interface SettingsLoader {
    public Map<String, String> load(String var1) throws IOException;

    public Map<String, String> load(byte[] var1) throws IOException;

    public static class Helper {
        public static Map<String, String> loadNestedFromMap(@Nullable Map map) {
            HashMap<String, String> settings = new HashMap<String, String>();
            if (map == null) {
                return settings;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<String> path = new ArrayList<String>();
            Helper.serializeMap(settings, sb, path, map);
            return settings;
        }

        private static void serializeMap(Map<String, String> settings, StringBuilder sb, List<String> path, Map<Object, Object> map) {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    path.add((String)entry.getKey());
                    Helper.serializeMap(settings, sb, path, (Map)entry.getValue());
                    path.remove(path.size() - 1);
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    path.add((String)entry.getKey());
                    Helper.serializeList(settings, sb, path, (List)entry.getValue());
                    path.remove(path.size() - 1);
                    continue;
                }
                Helper.serializeValue(settings, sb, path, (String)entry.getKey(), entry.getValue());
            }
        }

        private static void serializeList(Map<String, String> settings, StringBuilder sb, List<String> path, List list) {
            int counter = 0;
            for (Object listEle : list) {
                if (listEle instanceof Map) {
                    path.add(Integer.toString(counter));
                    Helper.serializeMap(settings, sb, path, (Map)listEle);
                    path.remove(path.size() - 1);
                } else if (listEle instanceof List) {
                    path.add(Integer.toString(counter));
                    Helper.serializeList(settings, sb, path, (List)listEle);
                    path.remove(path.size() - 1);
                } else {
                    Helper.serializeValue(settings, sb, path, Integer.toString(counter), listEle);
                }
                ++counter;
            }
        }

        private static void serializeValue(Map<String, String> settings, StringBuilder sb, List<String> path, String name, Object value) {
            if (value == null) {
                return;
            }
            sb.setLength(0);
            for (String pathEle : path) {
                sb.append(pathEle).append('.');
            }
            sb.append(name);
            settings.put(sb.toString(), value.toString());
        }
    }
}

