/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParsingException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.AbstractObjectParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ContextParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;

public final class ObjectParser<Value, Context>
extends AbstractObjectParser<Value, Context> {
    private final Map<String, FieldParser> fieldParserMap = new HashMap<String, FieldParser>();
    private final String name;
    private final Supplier<Value> valueSupplier;
    private final boolean ignoreUnknownFields;

    public static <Value, ElementValue> BiConsumer<Value, List<ElementValue>> fromList(Class<ElementValue> c, BiConsumer<Value, ElementValue[]> consumer) {
        return (v, l) -> {
            Object[] array = (Object[])Array.newInstance(c, l.size());
            consumer.accept(v, l.toArray(array));
        };
    }

    public ObjectParser(String name) {
        this(name, null);
    }

    public ObjectParser(String name, @Nullable Supplier<Value> valueSupplier) {
        this(name, false, valueSupplier);
    }

    public ObjectParser(String name, boolean ignoreUnknownFields, @Nullable Supplier<Value> valueSupplier) {
        this.name = name;
        this.valueSupplier = valueSupplier;
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    @Override
    public Value parse(XContentParser parser, Context context) throws IOException {
        if (this.valueSupplier == null) {
            throw new NullPointerException("valueSupplier is not set");
        }
        return this.parse(parser, this.valueSupplier.get(), context);
    }

    public Value parse(XContentParser parser, Value value, Context context) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            token = parser.currentToken();
        } else {
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalStateException("[" + this.name + "] Expected START_OBJECT but was: " + (Object)((Object)token));
            }
        }
        FieldParser fieldParser = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                fieldParser = this.getParser(currentFieldName);
                continue;
            }
            if (currentFieldName == null) {
                throw new IllegalStateException("[" + this.name + "] no field found");
            }
            if (fieldParser == null) {
                assert (this.ignoreUnknownFields) : "this should only be possible if configured to ignore known fields";
                parser.skipChildren();
            } else {
                fieldParser.assertSupports(this.name, token, currentFieldName);
                this.parseSub(parser, fieldParser, currentFieldName, value, context);
            }
            fieldParser = null;
        }
        return value;
    }

    @Override
    public Value apply(XContentParser parser, Context context) {
        if (this.valueSupplier == null) {
            throw new NullPointerException("valueSupplier is not set");
        }
        try {
            return this.parse(parser, this.valueSupplier.get(), context);
        }
        catch (IOException e) {
            throw new ParsingException(parser.getTokenLocation(), "[" + this.name + "] failed to parse object", e, new Object[0]);
        }
    }

    public void declareField(Parser<Value, Context> p, ParseField parseField, ValueType type) {
        if (parseField == null) {
            throw new IllegalArgumentException("[parseField] is required");
        }
        if (type == null) {
            throw new IllegalArgumentException("[type] is required");
        }
        FieldParser fieldParser = new FieldParser(p, type.supportedTokens(), parseField, type);
        for (String fieldValue : parseField.getAllNamesIncludedDeprecated()) {
            this.fieldParserMap.putIfAbsent(fieldValue, fieldParser);
        }
    }

    @Override
    public <T> void declareField(BiConsumer<Value, T> consumer, ContextParser<Context, T> parser, ParseField parseField, ValueType type) {
        if (consumer == null) {
            throw new IllegalArgumentException("[consumer] is required");
        }
        if (parser == null) {
            throw new IllegalArgumentException("[parser] is required");
        }
        this.declareField((p, v, c) -> consumer.accept(v, parser.parse(p, c)), parseField, type);
    }

    public <T> void declareObjectOrDefault(BiConsumer<Value, T> consumer, BiFunction<XContentParser, Context, T> objectParser, Supplier<T> defaultValue, ParseField field) {
        this.declareField((p, v, c) -> {
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                if (p.booleanValue()) {
                    consumer.accept(v, defaultValue.get());
                }
            } else {
                consumer.accept(v, objectParser.apply(p, c));
            }
        }, field, ValueType.OBJECT_OR_BOOLEAN);
    }

    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, NamedObjectParser<T, Context> namedObjectParser, Consumer<Value> orderedModeCallback, ParseField field) {
        BiFunction<XContentParser, Object, Object> objectParser = (p, c) -> {
            if (p.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(p.getTokenLocation(), "[" + field + "] can be a single object with any number of fields or an array where each entry is an object with a single field", new Object[0]);
            }
            try {
                String name = p.currentName();
                try {
                    return namedObjectParser.parse((XContentParser)p, (Object)c, name);
                }
                catch (Exception e) {
                    throw new ParsingException(p.getTokenLocation(), "[" + field + "] failed to parse field [" + name + "]", e, new Object[0]);
                }
            }
            catch (IOException e) {
                throw new ParsingException(p.getTokenLocation(), "[" + field + "] error while parsing", e, new Object[0]);
            }
        };
        this.declareField((p, v, c) -> {
            ArrayList fields = new ArrayList();
            if (p.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                while ((token = p.nextToken()) != XContentParser.Token.END_OBJECT) {
                    fields.add(objectParser.apply(p, c));
                }
            } else if (p.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token;
                orderedModeCallback.accept(v);
                while ((token = p.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.START_OBJECT) {
                        throw new ParsingException(p.getTokenLocation(), "[" + field + "] can be a single object with any number of fields or an array where each entry is an object with a single field", new Object[0]);
                    }
                    p.nextToken();
                    fields.add(objectParser.apply(p, c));
                    p.nextToken();
                    if (p.currentToken() == XContentParser.Token.END_OBJECT) continue;
                    throw new ParsingException(p.getTokenLocation(), "[" + field + "] can be a single object with any number of fields or an array where each entry is an object with a single field", new Object[0]);
                }
            }
            consumer.accept(v, fields);
        }, field, ValueType.OBJECT_ARRAY);
    }

    public <T> void declareNamedObjects(BiConsumer<Value, List<T>> consumer, NamedObjectParser<T, Context> namedObjectParser, ParseField field) {
        Consumer<Object> orderedModeCallback = v -> {
            throw new IllegalArgumentException("[" + field + "] doesn't support arrays. Use a single object with multiple fields.");
        };
        this.declareNamedObjects(consumer, namedObjectParser, orderedModeCallback, field);
    }

    public String getName() {
        return this.name;
    }

    private void parseArray(XContentParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.START_ARRAY) : "Token was: " + (Object)((Object)parser.currentToken());
        this.parseValue(parser, fieldParser, currentFieldName, value, context);
    }

    private void parseValue(XContentParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) throws IOException {
        try {
            fieldParser.parser.parse(parser, value, context);
        }
        catch (Exception ex) {
            throw new ParsingException(parser.getTokenLocation(), "[" + this.name + "] failed to parse field [" + currentFieldName + "]", ex, new Object[0]);
        }
    }

    private void parseSub(XContentParser parser, FieldParser fieldParser, String currentFieldName, Value value, Context context) throws IOException {
        XContentParser.Token token = parser.currentToken();
        switch (token) {
            case START_OBJECT: {
                this.parseValue(parser, fieldParser, currentFieldName, value, context);
                break;
            }
            case START_ARRAY: {
                this.parseArray(parser, fieldParser, currentFieldName, value, context);
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: 
            case FIELD_NAME: {
                throw new IllegalStateException("[" + this.name + "]" + (Object)((Object)token) + " is unexpected");
            }
            case VALUE_STRING: 
            case VALUE_NUMBER: 
            case VALUE_BOOLEAN: 
            case VALUE_EMBEDDED_OBJECT: 
            case VALUE_NULL: {
                this.parseValue(parser, fieldParser, currentFieldName, value, context);
            }
        }
    }

    private FieldParser getParser(String fieldName) {
        FieldParser parser = this.fieldParserMap.get(fieldName);
        if (parser == null && !this.ignoreUnknownFields) {
            throw new IllegalArgumentException("[" + this.name + "] unknown field [" + fieldName + "], parser not found");
        }
        return parser;
    }

    public String toString() {
        return "ObjectParser{name='" + this.name + '\'' + ", fields=" + this.fieldParserMap.values() + '}';
    }

    public static enum ValueType {
        STRING(XContentParser.Token.VALUE_STRING, new XContentParser.Token[0]),
        STRING_OR_NULL(XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        FLOAT(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        FLOAT_OR_NULL(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        DOUBLE(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        DOUBLE_OR_NULL(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        LONG(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        LONG_OR_NULL(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.VALUE_NULL),
        INT(XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        BOOLEAN(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_STRING),
        STRING_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_STRING),
        FLOAT_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        DOUBLE_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        LONG_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        INT_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        BOOLEAN_ARRAY(XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_BOOLEAN),
        OBJECT(XContentParser.Token.START_OBJECT, new XContentParser.Token[0]),
        OBJECT_ARRAY(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY),
        OBJECT_OR_BOOLEAN(XContentParser.Token.START_OBJECT, XContentParser.Token.VALUE_BOOLEAN),
        OBJECT_OR_STRING(XContentParser.Token.START_OBJECT, XContentParser.Token.VALUE_STRING),
        OBJECT_ARRAY_BOOLEAN_OR_STRING(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_STRING),
        OBJECT_ARRAY_OR_STRING(XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY, XContentParser.Token.VALUE_STRING),
        VALUE(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_NULL, XContentParser.Token.VALUE_EMBEDDED_OBJECT, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING),
        VALUE_OBJECT_ARRAY(XContentParser.Token.VALUE_BOOLEAN, XContentParser.Token.VALUE_NULL, XContentParser.Token.VALUE_EMBEDDED_OBJECT, XContentParser.Token.VALUE_NUMBER, XContentParser.Token.VALUE_STRING, XContentParser.Token.START_OBJECT, XContentParser.Token.START_ARRAY);

        private final EnumSet<XContentParser.Token> tokens;

        private ValueType(XContentParser.Token first, XContentParser.Token ... rest) {
            this.tokens = EnumSet.of(first, rest);
        }

        public EnumSet<XContentParser.Token> supportedTokens() {
            return this.tokens;
        }
    }

    private class FieldParser {
        private final Parser<Value, Context> parser;
        private final EnumSet<XContentParser.Token> supportedTokens;
        private final ParseField parseField;
        private final ValueType type;

        FieldParser(Parser<Value, Context> parser, EnumSet<XContentParser.Token> supportedTokens, ParseField parseField, ValueType type) {
            this.parser = parser;
            this.supportedTokens = supportedTokens;
            this.parseField = parseField;
            this.type = type;
        }

        void assertSupports(String parserName, XContentParser.Token token, String currentFieldName) {
            if (!this.parseField.match(currentFieldName)) {
                throw new IllegalStateException("[" + parserName + "] parsefield doesn't accept: " + currentFieldName);
            }
            if (!this.supportedTokens.contains((Object)token)) {
                throw new IllegalArgumentException("[" + parserName + "] " + currentFieldName + " doesn't support values of type: " + (Object)((Object)token));
            }
        }

        public String toString() {
            Object[] deprecatedNames = this.parseField.getDeprecatedNames();
            String allReplacedWith = this.parseField.getAllReplacedWith();
            String deprecated = "";
            if (deprecatedNames != null && deprecatedNames.length > 0) {
                deprecated = ", deprecated_names=" + Arrays.toString(deprecatedNames);
            }
            return "FieldParser{preferred_name=" + this.parseField.getPreferredName() + ", supportedTokens=" + this.supportedTokens + deprecated + (allReplacedWith == null ? "" : ", replaced_with=" + allReplacedWith) + ", type=" + this.type.name() + '}';
        }
    }

    @FunctionalInterface
    public static interface NamedObjectParser<T, Context> {
        public T parse(XContentParser var1, Context var2, String var3) throws IOException;
    }

    public static interface Parser<Value, Context> {
        public void parse(XContentParser var1, Value var2, Context var3) throws IOException;
    }
}

