/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;

public class AlreadyExpiredException
extends ElasticsearchException
implements IgnoreOnRecoveryEngineException {
    private String index;
    private String type;
    private String id;
    private final long timestamp;
    private final long ttl;
    private final long now;

    public AlreadyExpiredException(String index, String type, String id, long timestamp, long ttl, long now) {
        super("already expired [" + index + "]/[" + type + "]/[" + id + "] due to expire at [" + (timestamp + ttl) + "] and was processed at [" + now + "]", new Object[0]);
        this.setIndex(index);
        this.type = type;
        this.id = id;
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.now = now;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long ttl() {
        return this.ttl;
    }

    public long now() {
        return this.now;
    }

    public AlreadyExpiredException(StreamInput in) throws IOException {
        super(in);
        this.index = in.readOptionalString();
        this.type = in.readOptionalString();
        this.id = in.readOptionalString();
        this.timestamp = in.readLong();
        this.ttl = in.readLong();
        this.now = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.index);
        out.writeOptionalString(this.type);
        out.writeOptionalString(this.id);
        out.writeLong(this.timestamp);
        out.writeLong(this.ttl);
        out.writeLong(this.now);
    }
}

