/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.plain;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.FieldData;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

abstract class AtomicLongFieldData
implements AtomicNumericFieldData {
    private final long ramBytesUsed;
    private final boolean isBoolean;

    AtomicLongFieldData(long ramBytesUsed, boolean isBoolean) {
        this.ramBytesUsed = ramBytesUsed;
        this.isBoolean = isBoolean;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final ScriptDocValues getScriptValues() {
        if (this.isBoolean) {
            return new ScriptDocValues.Booleans(this.getLongValues());
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getLongValues());
    }

    @Override
    public final SortedNumericDoubleValues getDoubleValues() {
        return FieldData.castToDouble(this.getLongValues());
    }

    @Override
    public void close() {
    }
}

