/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.Action;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.index.IndexAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.index.IndexRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.index.IndexRequestBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchAction;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchRequestBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.ElasticsearchClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex.AbstractBulkIndexByScrollRequestBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex.ReindexRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.reindex.RemoteInfo;

public class ReindexRequestBuilder
extends AbstractBulkIndexByScrollRequestBuilder<ReindexRequest, ReindexRequestBuilder> {
    private final IndexRequestBuilder destination;

    public ReindexRequestBuilder(ElasticsearchClient client, Action<ReindexRequest, BulkByScrollResponse, ReindexRequestBuilder> action) {
        this(client, action, new SearchRequestBuilder(client, SearchAction.INSTANCE), new IndexRequestBuilder(client, IndexAction.INSTANCE));
    }

    private ReindexRequestBuilder(ElasticsearchClient client, Action<ReindexRequest, BulkByScrollResponse, ReindexRequestBuilder> action, SearchRequestBuilder search, IndexRequestBuilder destination) {
        super(client, action, search, new ReindexRequest((SearchRequest)search.request(), (IndexRequest)destination.request()));
        this.destination = destination;
    }

    @Override
    protected ReindexRequestBuilder self() {
        return this;
    }

    public IndexRequestBuilder destination() {
        return this.destination;
    }

    public ReindexRequestBuilder destination(String index) {
        this.destination.setIndex(index);
        return this;
    }

    public ReindexRequestBuilder destination(String index, String type) {
        ((IndexRequestBuilder)this.destination.setIndex(index)).setType(type);
        return this;
    }

    public ReindexRequestBuilder setRemoteInfo(RemoteInfo remoteInfo) {
        ((ReindexRequest)this.request()).setRemoteInfo(remoteInfo);
        return this;
    }
}

