/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFormatTooNewException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFormatTooOldException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.InputStreamDataInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.BaseTranslogReader;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.Checkpoint;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.translog.TranslogCorruptedException;

public class TranslogReader
extends BaseTranslogReader
implements Closeable {
    private static final byte LUCENE_CODEC_HEADER_BYTE = 63;
    private static final byte UNVERSIONED_TRANSLOG_HEADER_BYTE = 0;
    private final int totalOperations;
    protected final long length;
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    public TranslogReader(long generation, FileChannel channel, Path path, long firstOperationOffset, long length, int totalOperations) {
        super(generation, channel, path, firstOperationOffset);
        this.length = length;
        this.totalOperations = totalOperations;
    }

    public static TranslogReader open(FileChannel channel, Path path, Checkpoint checkpoint, String translogUUID) throws IOException {
        try {
            InputStreamStreamInput headerStream = new InputStreamStreamInput(Channels.newInputStream(channel));
            byte b1 = headerStream.readByte();
            if (b1 == 63) {
                byte b4;
                byte b3;
                byte b2 = headerStream.readByte();
                int header = ((b1 & 0xFF) << 24) + ((b2 & 0xFF) << 16) + (((b3 = headerStream.readByte()) & 0xFF) << 8) + (((b4 = headerStream.readByte()) & 0xFF) << 0);
                if (header != 1071082519) {
                    throw new TranslogCorruptedException("translog looks like version 1 or later, but has corrupted header. path:" + path);
                }
                int version = CodecUtil.checkHeaderNoMagic(new InputStreamDataInput(headerStream), "translog", 1, Integer.MAX_VALUE);
                switch (version) {
                    case 1: {
                        throw new IllegalStateException("pre-2.0 translog found [" + path + "]");
                    }
                    case 2: {
                        assert (path.getFileName().toString().endsWith(".tlog")) : "new file ends with old suffix: " + path;
                        assert (checkpoint.numOps >= 0) : "expected at least 0 operatin but got: " + checkpoint.numOps;
                        assert (checkpoint.offset <= channel.size()) : "checkpoint is inconsistent with channel length: " + channel.size() + " " + checkpoint;
                        int len = headerStream.readInt();
                        if ((long)len > channel.size()) {
                            throw new TranslogCorruptedException("uuid length can't be larger than the translog");
                        }
                        BytesRef ref = new BytesRef(len);
                        ref.length = len;
                        headerStream.read(ref.bytes, ref.offset, ref.length);
                        BytesRef uuidBytes = new BytesRef(translogUUID);
                        if (!uuidBytes.bytesEquals(ref)) {
                            throw new TranslogCorruptedException("expected shard UUID " + uuidBytes + " but got: " + ref + " this translog file belongs to a different translog. path:" + path);
                        }
                        return new TranslogReader(checkpoint.generation, channel, path, ref.length + CodecUtil.headerLength("translog") + 4, checkpoint.offset, checkpoint.numOps);
                    }
                }
                throw new TranslogCorruptedException("No known translog stream version: " + version + " path:" + path);
            }
            if (b1 == 0) {
                throw new IllegalStateException("pre-1.4 translog found [" + path + "]");
            }
            throw new TranslogCorruptedException("Invalid first byte in translog file, got: " + Long.toHexString(b1) + ", expected 0x00 or 0x3f. path:" + path);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException e) {
            throw new TranslogCorruptedException("Translog header corrupted. path:" + path, e);
        }
    }

    @Override
    public long sizeInBytes() {
        return this.length;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        if (position >= this.length) {
            throw new EOFException("read requested past EOF. pos [" + position + "] end: [" + this.length + "]");
        }
        if (position < this.firstOperationOffset) {
            throw new IOException("read requested before position of first ops. pos [" + position + "] first op on: [" + this.firstOperationOffset + "]");
        }
        org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.Channels.readFromFileChannelWithEofException(this.channel, position, buffer);
    }

    public Checkpoint getInfo() {
        return new Checkpoint(this.length, this.totalOperations, this.getGeneration());
    }

    @Override
    public final void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.channel.close();
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    protected void ensureOpen() {
        if (this.isClosed()) {
            throw new AlreadyClosedException(this.toString() + " is already closed");
        }
    }
}

