/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ExceptionsHelper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.RoutingNode;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.routing.ShardRouting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.cluster.service.ClusterService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.component.AbstractComponent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lease.Releasable;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.IndexService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexEventListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.IndexShard;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.shard.ShardId;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.IndicesService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RecoveryResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RecoverySettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.RemoteRecoveryTargetHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.SharedFSRecoverySourceHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.transport.TransportService;

public class PeerRecoverySourceService
extends AbstractComponent
implements IndexEventListener {
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;
    private final OngoingRecoveries ongoingRecoveries = new OngoingRecoveries();

    @Inject
    public PeerRecoverySourceService(Settings settings, TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings, ClusterService clusterService) {
        super(settings);
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
        transportService.registerRequestHandler("internal:index/shard/recovery/start_recovery", StartRecoveryRequest::new, "generic", new StartRecoveryTransportRequestHandler());
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.ongoingRecoveries.cancel(indexShard, "shard is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryResponse recover(StartRecoveryRequest request) throws IOException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        RoutingNode node = this.clusterService.state().getRoutingNodes().node(request.targetNode().getId());
        if (node == null) {
            this.logger.debug("delaying recovery of {} as source node {} is unknown", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source node does not have the node [" + request.targetNode() + "] in its state yet..");
        }
        ShardRouting routingEntry = shard.routingEntry();
        if (!(!request.isPrimaryRelocation() || routingEntry.relocating() && routingEntry.relocatingNodeId().equals(request.targetNode().getId()))) {
            this.logger.debug("delaying recovery of {} as source shard is not marked yet as relocating to {}", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source shard is not marked yet as relocating to [" + request.targetNode() + "]");
        }
        ShardRouting targetShardRouting = node.getByShardId(request.shardId());
        if (targetShardRouting == null) {
            this.logger.debug("delaying recovery of {} as it is not listed as assigned to target node {}", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
        }
        if (!targetShardRouting.initializing()) {
            this.logger.debug("delaying recovery of {} as it is not listed as initializing on the target node {}. known shards state is [{}]", (Object)request.shardId(), (Object)request.targetNode(), (Object)targetShardRouting.state());
            throw new DelayRecoveryException("source node has the state of the target shard to be [" + (Object)((Object)targetShardRouting.state()) + "], expecting to be [initializing]");
        }
        if (request.targetAllocationId() == null) {
            request = new StartRecoveryRequest(request.shardId(), targetShardRouting.allocationId().getId(), request.sourceNode(), request.targetNode(), request.metadataSnapshot(), request.isPrimaryRelocation(), request.recoveryId());
        }
        if (!request.targetAllocationId().equals(targetShardRouting.allocationId().getId())) {
            this.logger.debug("delaying recovery of {} due to target allocation id mismatch (expected: [{}], but was: [{}])", (Object)request.shardId(), (Object)request.targetAllocationId(), (Object)targetShardRouting.allocationId().getId());
            throw new DelayRecoveryException("source node has the state of the target shard to have allocation id [" + targetShardRouting.allocationId().getId() + "], expecting to be [" + request.targetAllocationId() + "]");
        }
        RecoverySourceHandler handler = this.ongoingRecoveries.addNewRecovery(request, shard);
        this.logger.trace("[{}][{}] starting recovery to {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.targetNode());
        try {
            RecoveryResponse recoveryResponse = handler.recoverToTarget();
            return recoveryResponse;
        }
        finally {
            this.ongoingRecoveries.remove(shard, handler);
        }
    }

    private final class OngoingRecoveries {
        private final Map<IndexShard, ShardRecoveryContext> ongoingRecoveries = new HashMap<IndexShard, ShardRecoveryContext>();

        private OngoingRecoveries() {
        }

        synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
            ShardRecoveryContext shardContext = this.ongoingRecoveries.computeIfAbsent(shard, s -> new ShardRecoveryContext());
            RecoverySourceHandler handler = shardContext.addNewRecovery(request, shard);
            shard.recoveryStats().incCurrentAsSource();
            return handler;
        }

        synchronized void remove(IndexShard shard, RecoverySourceHandler handler) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            assert (shardRecoveryContext != null) : "Shard was not registered [" + shard + "]";
            boolean remove = shardRecoveryContext.recoveryHandlers.remove(handler);
            assert (remove) : "Handler was not registered [" + handler + "]";
            if (remove) {
                shard.recoveryStats().decCurrentAsSource();
            }
            if (shardRecoveryContext.recoveryHandlers.isEmpty()) {
                this.ongoingRecoveries.remove(shard);
                assert (shardRecoveryContext.onNewRecoveryException == null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel(IndexShard shard, String reason) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            if (shardRecoveryContext != null) {
                ArrayList<Exception> failures = new ArrayList<Exception>();
                for (RecoverySourceHandler handlers : shardRecoveryContext.recoveryHandlers) {
                    try {
                        handlers.cancel(reason);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                    }
                    finally {
                        shard.recoveryStats().decCurrentAsSource();
                    }
                }
                ExceptionsHelper.maybeThrowRuntimeAndSuppress(failures);
            }
        }

        private final class ShardRecoveryContext {
            final Set<RecoverySourceHandler> recoveryHandlers = new HashSet<RecoverySourceHandler>();
            @Nullable
            private DelayRecoveryException onNewRecoveryException;

            private ShardRecoveryContext() {
            }

            synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
                if (this.onNewRecoveryException != null) {
                    throw this.onNewRecoveryException;
                }
                RecoverySourceHandler handler = this.createRecoverySourceHandler(request, shard);
                this.recoveryHandlers.add(handler);
                return handler;
            }

            private RecoverySourceHandler createRecoverySourceHandler(StartRecoveryRequest request, IndexShard shard) {
                RemoteRecoveryTargetHandler recoveryTarget = new RemoteRecoveryTargetHandler(request.recoveryId(), request.shardId(), PeerRecoverySourceService.this.transportService, request.targetNode(), PeerRecoverySourceService.this.recoverySettings, throttleTime -> shard.recoveryStats().addThrottleTime((long)throttleTime));
                Supplier<Long> currentClusterStateVersionSupplier = () -> PeerRecoverySourceService.this.clusterService.state().getVersion();
                RecoverySourceHandler handler = shard.indexSettings().isOnSharedFilesystem() ? new SharedFSRecoverySourceHandler(shard, recoveryTarget, request, currentClusterStateVersionSupplier, this::delayNewRecoveries, PeerRecoverySourceService.this.logger) : new RecoverySourceHandler(shard, recoveryTarget, request, currentClusterStateVersionSupplier, this::delayNewRecoveries, PeerRecoverySourceService.this.recoverySettings.getChunkSize().bytesAsInt(), PeerRecoverySourceService.this.logger);
                return handler;
            }

            synchronized Releasable delayNewRecoveries(String exceptionMessage) throws IllegalStateException {
                if (this.onNewRecoveryException != null) {
                    throw new IllegalStateException("already delaying recoveries");
                }
                this.onNewRecoveryException = new DelayRecoveryException(exceptionMessage);
                return this::unblockNewRecoveries;
            }

            private synchronized void unblockNewRecoveries() {
                this.onNewRecoveryException = null;
            }
        }
    }

    class StartRecoveryTransportRequestHandler
    implements TransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel) throws Exception {
            RecoveryResponse response = PeerRecoverySourceService.this.recover(request);
            channel.sendResponse(response);
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
    }
}

