/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ElasticsearchException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestDocument;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.Processor;

public class CompoundProcessor
implements Processor {
    public static final String ON_FAILURE_MESSAGE_FIELD = "on_failure_message";
    public static final String ON_FAILURE_PROCESSOR_TYPE_FIELD = "on_failure_processor_type";
    public static final String ON_FAILURE_PROCESSOR_TAG_FIELD = "on_failure_processor_tag";
    private final boolean ignoreFailure;
    private final List<Processor> processors;
    private final List<Processor> onFailureProcessors;

    public CompoundProcessor(Processor ... processor) {
        this(false, Arrays.asList(processor), Collections.emptyList());
    }

    public CompoundProcessor(boolean ignoreFailure, List<Processor> processors, List<Processor> onFailureProcessors) {
        this.ignoreFailure = ignoreFailure;
        this.processors = processors;
        this.onFailureProcessors = onFailureProcessors;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public List<Processor> getOnFailureProcessors() {
        return this.onFailureProcessors;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public List<Processor> flattenProcessors() {
        ArrayList<Processor> allProcessors = new ArrayList<Processor>(CompoundProcessor.flattenProcessors(this.processors));
        allProcessors.addAll(CompoundProcessor.flattenProcessors(this.onFailureProcessors));
        return allProcessors;
    }

    private static List<Processor> flattenProcessors(List<Processor> processors) {
        ArrayList<Processor> flattened = new ArrayList<Processor>();
        for (Processor processor : processors) {
            if (processor instanceof CompoundProcessor) {
                flattened.addAll(((CompoundProcessor)processor).flattenProcessors());
                continue;
            }
            flattened.add(processor);
        }
        return flattened;
    }

    @Override
    public String getType() {
        return "compound";
    }

    @Override
    public String getTag() {
        return "CompoundProcessor-" + this.flattenProcessors().stream().map(Processor::getTag).collect(Collectors.joining("-"));
    }

    @Override
    public void execute(IngestDocument ingestDocument) throws Exception {
        for (Processor processor : this.processors) {
            try {
                processor.execute(ingestDocument);
            }
            catch (Exception e) {
                if (this.ignoreFailure) continue;
                ElasticsearchException compoundProcessorException = this.newCompoundProcessorException(e, processor.getType(), processor.getTag());
                if (this.onFailureProcessors.isEmpty()) {
                    throw compoundProcessorException;
                }
                this.executeOnFailure(ingestDocument, compoundProcessorException);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void executeOnFailure(IngestDocument ingestDocument, ElasticsearchException exception) throws Exception {
        try {
            this.putFailureMetadata(ingestDocument, exception);
            for (Processor processor : this.onFailureProcessors) {
                try {
                    processor.execute(ingestDocument);
                }
                catch (Exception e) {
                    throw this.newCompoundProcessorException(e, processor.getType(), processor.getTag());
                    return;
                }
            }
        }
        finally {
            this.removeFailureMetadata(ingestDocument);
        }
    }

    private void putFailureMetadata(IngestDocument ingestDocument, ElasticsearchException cause) {
        List<String> processorTypeHeader = cause.getHeader("processor_type");
        List<String> processorTagHeader = cause.getHeader("processor_tag");
        String failedProcessorType = processorTypeHeader != null ? processorTypeHeader.get(0) : null;
        String failedProcessorTag = processorTagHeader != null ? processorTagHeader.get(0) : null;
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.put(ON_FAILURE_MESSAGE_FIELD, cause.getRootCause().getMessage());
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TYPE_FIELD, failedProcessorType);
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TAG_FIELD, failedProcessorTag);
    }

    private void removeFailureMetadata(IngestDocument ingestDocument) {
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.remove(ON_FAILURE_MESSAGE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TYPE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TAG_FIELD);
    }

    private ElasticsearchException newCompoundProcessorException(Exception e, String processorType, String processorTag) {
        if (e instanceof ElasticsearchException && ((ElasticsearchException)e).getHeader("processor_type") != null) {
            return (ElasticsearchException)e;
        }
        ElasticsearchException exception = new ElasticsearchException(new IllegalArgumentException(e));
        if (processorType != null) {
            exception.addHeader("processor_type", processorType);
        }
        if (processorTag != null) {
            exception.addHeader("processor_tag", processorTag);
        }
        return exception;
    }
}

