/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.ClusterSettings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Setting;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.env.Environment;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.analysis.AnalysisRegistry;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.IngestInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.InternalTemplateService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.PipelineExecutionService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.PipelineStore;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.Processor;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.ingest.ProcessorInfo;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.plugins.IngestPlugin;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.script.ScriptService;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.threadpool.ThreadPool;

public class IngestService {
    public static final Setting<Boolean> NEW_INGEST_DATE_FORMAT = Setting.boolSetting("ingest.new_date_format", false, Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated);
    private final PipelineStore pipelineStore;
    private final PipelineExecutionService pipelineExecutionService;

    public IngestService(ClusterSettings clusterSettings, Settings settings, ThreadPool threadPool, Environment env, ScriptService scriptService, AnalysisRegistry analysisRegistry, List<IngestPlugin> ingestPlugins) {
        InternalTemplateService templateService = new InternalTemplateService(scriptService);
        Processor.Parameters parameters = new Processor.Parameters(env, scriptService, templateService, analysisRegistry, threadPool.getThreadContext());
        HashMap<String, Processor.Factory> processorFactories = new HashMap<String, Processor.Factory>();
        for (IngestPlugin ingestPlugin : ingestPlugins) {
            Map<String, Processor.Factory> newProcessors = ingestPlugin.getProcessors(parameters);
            for (Map.Entry<String, Processor.Factory> entry : newProcessors.entrySet()) {
                if (processorFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Ingest processor [" + entry.getKey() + "] is already registered");
            }
        }
        this.pipelineStore = new PipelineStore(clusterSettings, settings, Collections.unmodifiableMap(processorFactories));
        this.pipelineExecutionService = new PipelineExecutionService(this.pipelineStore, threadPool);
    }

    public PipelineStore getPipelineStore() {
        return this.pipelineStore;
    }

    public PipelineExecutionService getPipelineExecutionService() {
        return this.pipelineExecutionService;
    }

    public IngestInfo info() {
        Map<String, Processor.Factory> processorFactories = this.pipelineStore.getProcessorFactories();
        ArrayList<ProcessorInfo> processorInfoList = new ArrayList<ProcessorInfo>(processorFactories.size());
        for (Map.Entry<String, Processor.Factory> entry : processorFactories.entrySet()) {
            processorInfoList.add(new ProcessorInfo(entry.getKey()));
        }
        return new IngestInfo(processorInfoList);
    }
}

