/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.AcknowledgedRestListener;

public class RestIndicesAliasesAction
extends BaseRestHandler {
    static final ObjectParser<IndicesAliasesRequest, Void> PARSER = new ObjectParser("aliases");

    public RestIndicesAliasesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_aliases", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", indicesAliasesRequest.masterNodeTimeout()));
        indicesAliasesRequest.timeout(request.paramAsTime("timeout", indicesAliasesRequest.timeout()));
        try (XContentParser parser = request.contentParser();){
            PARSER.parse(parser, indicesAliasesRequest, null);
        }
        if (indicesAliasesRequest.getAliasActions().isEmpty()) {
            throw new IllegalArgumentException("No action specified");
        }
        return channel -> client.admin().indices().aliases(indicesAliasesRequest, new AcknowledgedRestListener<IndicesAliasesResponse>((RestChannel)channel));
    }

    static {
        PARSER.declareObjectArray((request, actions) -> {
            for (IndicesAliasesRequest.AliasActions action : actions) {
                request.addAliasAction(action);
            }
        }, IndicesAliasesRequest.AliasActions.PARSER, new ParseField("actions", new String[0]));
    }
}

