/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.recovery.RecoveryRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BytesRestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestStatus;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestBuilderListener;

public class RestRecoveryAction
extends BaseRestHandler {
    public RestRecoveryAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_recovery", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_recovery", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        final RecoveryRequest recoveryRequest = new RecoveryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        recoveryRequest.detailed(request.paramAsBoolean("detailed", false));
        recoveryRequest.activeOnly(request.paramAsBoolean("active_only", false));
        recoveryRequest.indicesOptions(IndicesOptions.fromRequest(request, recoveryRequest.indicesOptions()));
        return channel -> client.admin().indices().recoveries(recoveryRequest, (ActionListener<RecoveryResponse>)new RestBuilderListener<RecoveryResponse>(channel){

            @Override
            public RestResponse buildResponse(RecoveryResponse response, XContentBuilder builder) throws Exception {
                response.detailed(recoveryRequest.detailed());
                builder.startObject();
                response.toXContent(builder, request);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

