/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.search;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.action.search.SearchScrollRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.bytes.BytesReference;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestController;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.Scroll;

public class RestSearchScrollAction
extends BaseRestHandler {
    public RestSearchScrollAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll", this);
        controller.registerHandler(RestRequest.Method.GET, "/_search/scroll/{scroll_id}", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/scroll/{scroll_id}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String scrollId = request.param("scroll_id");
        SearchScrollRequest searchScrollRequest = new SearchScrollRequest();
        searchScrollRequest.scrollId(scrollId);
        String scroll = request.param("scroll");
        if (scroll != null) {
            searchScrollRequest.scroll(new Scroll(TimeValue.parseTimeValue(scroll, null, "scroll")));
        }
        request.withContentOrSourceParamParserOrNullLenient(xContentParser -> {
            if (xContentParser == null) {
                if (request.hasContent()) {
                    BytesReference body = request.getContentOrSourceParamOnly();
                    if (scrollId == null) {
                        String bodyScrollId = body.utf8ToString();
                        searchScrollRequest.scrollId(bodyScrollId);
                    }
                }
            } else {
                try {
                    searchScrollRequest.fromXContent((XContentParser)xContentParser);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to parse request body", e);
                }
            }
        });
        return channel -> client.searchScroll(searchScrollRequest, new RestStatusToXContentListener<SearchResponse>((RestChannel)channel));
    }

    @Override
    public boolean supportsPlainText() {
        return true;
    }
}

