/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.script;

import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.Strings;

public interface ScriptContext {
    public String getKey();

    public static final class Plugin
    implements ScriptContext {
        private final String pluginName;
        private final String operation;
        private final String key;

        public Plugin(String pluginName, String operation) {
            if (!Strings.hasLength(pluginName)) {
                throw new IllegalArgumentException("plugin name cannot be empty when registering a custom script context");
            }
            if (!Strings.hasLength(operation)) {
                throw new IllegalArgumentException("operation name cannot be empty when registering a custom script context");
            }
            this.pluginName = pluginName;
            this.operation = operation;
            this.key = pluginName + "_" + operation;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public String getOperation() {
            return this.operation;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.getKey();
        }
    }

    public static enum Standard implements ScriptContext
    {
        AGGS("aggs"),
        SEARCH("search"),
        UPDATE("update"),
        INGEST("ingest");

        private final String key;

        private Standard(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.getKey();
        }
    }
}

