/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Sort;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TopFieldDocs;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchHits;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalTopHits
extends InternalAggregation
implements TopHits {
    private int from;
    private int size;
    private TopDocs topDocs;
    private SearchHits searchHits;

    public InternalTopHits(String name, int from, int size, TopDocs topDocs, SearchHits searchHits, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.from = from;
        this.size = size;
        this.topDocs = topDocs;
        this.searchHits = searchHits;
    }

    public InternalTopHits(StreamInput in) throws IOException {
        super(in);
        this.from = in.readVInt();
        this.size = in.readVInt();
        this.topDocs = Lucene.readTopDocs(in);
        assert (this.topDocs != null);
        this.searchHits = SearchHits.readSearchHits(in);
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        Lucene.writeTopDocs(out, this.topDocs);
        this.searchHits.writeTo(out);
    }

    @Override
    public String getWriteableName() {
        return "top_hits";
    }

    @Override
    public SearchHits getHits() {
        return this.searchHits;
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        TopDocs reducedTopDocs;
        TopDocs[] shardDocs;
        int size;
        int from;
        SearchHits[] shardHits = new SearchHits[aggregations.size()];
        if (reduceContext.isFinalReduce()) {
            from = this.from;
            size = this.size;
        } else {
            from = 0;
            size = this.from + this.size;
        }
        if (this.topDocs instanceof TopFieldDocs) {
            Sort sort = new Sort(((TopFieldDocs)this.topDocs).fields);
            shardDocs = new TopFieldDocs[aggregations.size()];
            for (int i = 0; i < shardDocs.length; ++i) {
                InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
                shardDocs[i] = topHitsAgg.topDocs;
                shardHits[i] = topHitsAgg.searchHits;
            }
            reducedTopDocs = TopDocs.merge(sort, from, size, (TopFieldDocs[])shardDocs, true);
        } else {
            shardDocs = new TopDocs[aggregations.size()];
            for (int i = 0; i < shardDocs.length; ++i) {
                InternalTopHits topHitsAgg = (InternalTopHits)aggregations.get(i);
                shardDocs[i] = topHitsAgg.topDocs;
                shardHits[i] = topHitsAgg.searchHits;
            }
            reducedTopDocs = TopDocs.merge(from, size, shardDocs, true);
        }
        int[] tracker = new int[shardHits.length];
        SearchHit[] hits = new SearchHit[reducedTopDocs.scoreDocs.length];
        for (int i = 0; i < reducedTopDocs.scoreDocs.length; ++i) {
            int position;
            ScoreDoc scoreDoc = reducedTopDocs.scoreDocs[i];
            do {
                int n = scoreDoc.shardIndex;
                tracker[n] = tracker[n] + 1;
            } while (shardDocs[scoreDoc.shardIndex].scoreDocs[position] != scoreDoc);
            hits[i] = shardHits[scoreDoc.shardIndex].getAt(position);
        }
        return new InternalTopHits(this.name, this.from, this.size, reducedTopDocs, new SearchHits(hits, reducedTopDocs.totalHits, reducedTopDocs.getMaxScore()), this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.searchHits.toXContent(builder, params);
        return builder;
    }
}

