/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.document.TextField;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.mapper.FieldMapper;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.fetch.subphase.highlight.SimpleFragmentsBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.internal.SearchContext;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.lookup.SourceLookup;

public class SourceSimpleFragmentsBuilder
extends SimpleFragmentsBuilder {
    private final SearchContext searchContext;
    public static final Field[] EMPTY_FIELDS = new Field[0];

    public SourceSimpleFragmentsBuilder(FieldMapper mapper, SearchContext searchContext, String[] preTags, String[] postTags, BoundaryScanner boundaryScanner) {
        super(mapper, preTags, postTags, boundaryScanner);
        this.searchContext = searchContext;
    }

    @Override
    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        SourceLookup sourceLookup = this.searchContext.lookup().source();
        sourceLookup.setSegmentAndDocument((LeafReaderContext)reader.getContext(), docId);
        List<Object> values = sourceLookup.extractRawValues(this.mapper.fieldType().name());
        if (values.isEmpty()) {
            return EMPTY_FIELDS;
        }
        Field[] fields = new Field[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            fields[i] = new Field(this.mapper.fieldType().name(), values.get(i).toString(), TextField.TYPE_NOT_STORED);
        }
        return fields;
    }
}

