/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.FieldDoc;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.common.lucene.Lucene;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.DocValueFormat;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchPhaseResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.SearchShardTarget;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.Aggregations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.InternalAggregations;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.profile.ProfileShardResult;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.suggest.Suggest;

public final class QuerySearchResult
extends SearchPhaseResult {
    private int from;
    private int size;
    private TopDocs topDocs;
    private DocValueFormat[] sortValueFormats;
    private InternalAggregations aggregations;
    private boolean hasAggs;
    private List<SiblingPipelineAggregator> pipelineAggregators;
    private Suggest suggest;
    private boolean searchTimedOut;
    private Boolean terminatedEarly = null;
    private ProfileShardResult profileShardResults;
    private boolean hasProfileResults;
    private boolean hasScoreDocs;
    private int totalHits;
    private float maxScore;

    public QuerySearchResult() {
    }

    public QuerySearchResult(long id, SearchShardTarget shardTarget) {
        this.requestId = id;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public QuerySearchResult queryResult() {
        return this;
    }

    public void searchTimedOut(boolean searchTimedOut) {
        this.searchTimedOut = searchTimedOut;
    }

    public boolean searchTimedOut() {
        return this.searchTimedOut;
    }

    public void terminatedEarly(boolean terminatedEarly) {
        this.terminatedEarly = terminatedEarly;
    }

    public Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public TopDocs topDocs() {
        if (this.topDocs == null) {
            throw new IllegalStateException("topDocs already consumed");
        }
        return this.topDocs;
    }

    public boolean hasConsumedTopDocs() {
        return this.topDocs == null;
    }

    public TopDocs consumeTopDocs() {
        TopDocs topDocs = this.topDocs;
        if (topDocs == null) {
            throw new IllegalStateException("topDocs already consumed");
        }
        this.topDocs = null;
        return topDocs;
    }

    public void topDocs(TopDocs topDocs, DocValueFormat[] sortValueFormats) {
        int numFields;
        this.setTopDocs(topDocs);
        if (topDocs.scoreDocs.length > 0 && topDocs.scoreDocs[0] instanceof FieldDoc && (numFields = ((FieldDoc)topDocs.scoreDocs[0]).fields.length) != sortValueFormats.length) {
            throw new IllegalArgumentException("The number of sort fields does not match: " + numFields + " != " + sortValueFormats.length);
        }
        this.sortValueFormats = sortValueFormats;
    }

    private void setTopDocs(TopDocs topDocs) {
        this.topDocs = topDocs;
        this.hasScoreDocs = topDocs.scoreDocs.length > 0;
        this.totalHits = topDocs.totalHits;
        this.maxScore = topDocs.getMaxScore();
    }

    public DocValueFormat[] sortValueFormats() {
        return this.sortValueFormats;
    }

    public boolean hasAggs() {
        return this.hasAggs;
    }

    public Aggregations consumeAggs() {
        if (this.aggregations == null) {
            throw new IllegalStateException("aggs already consumed");
        }
        InternalAggregations aggs = this.aggregations;
        this.aggregations = null;
        return aggs;
    }

    public void aggregations(InternalAggregations aggregations) {
        this.aggregations = aggregations;
        this.hasAggs = aggregations != null;
    }

    public ProfileShardResult consumeProfileResult() {
        if (this.profileShardResults == null) {
            throw new IllegalStateException("profile results already consumed");
        }
        ProfileShardResult result = this.profileShardResults;
        this.profileShardResults = null;
        return result;
    }

    public boolean hasProfileResults() {
        return this.hasProfileResults;
    }

    public void profileResults(ProfileShardResult shardResults) {
        this.profileShardResults = shardResults;
        this.hasProfileResults = shardResults != null;
    }

    public List<SiblingPipelineAggregator> pipelineAggregators() {
        return this.pipelineAggregators;
    }

    public void pipelineAggregators(List<SiblingPipelineAggregator> pipelineAggregators) {
        this.pipelineAggregators = pipelineAggregators;
    }

    public Suggest suggest() {
        return this.suggest;
    }

    public void suggest(Suggest suggest) {
        this.suggest = suggest;
    }

    public int from() {
        return this.from;
    }

    public QuerySearchResult from(int from) {
        this.from = from;
        return this;
    }

    public int size() {
        return this.size;
    }

    public QuerySearchResult size(int size) {
        this.size = size;
        return this;
    }

    public boolean hasSuggestHits() {
        return this.suggest != null && this.suggest.hasScoreDocs();
    }

    public boolean hasSearchContext() {
        return this.hasScoreDocs || this.hasSuggestHits();
    }

    public static QuerySearchResult readQuerySearchResult(StreamInput in) throws IOException {
        QuerySearchResult result = new QuerySearchResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        long id = in.readLong();
        this.readFromWithId(id, in);
    }

    public void readFromWithId(long id, StreamInput in) throws IOException {
        this.requestId = id;
        this.from = in.readVInt();
        this.size = in.readVInt();
        int numSortFieldsPlus1 = in.readVInt();
        if (numSortFieldsPlus1 == 0) {
            this.sortValueFormats = null;
        } else {
            this.sortValueFormats = new DocValueFormat[numSortFieldsPlus1 - 1];
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                this.sortValueFormats[i] = in.readNamedWriteable(DocValueFormat.class);
            }
        }
        this.setTopDocs(Lucene.readTopDocs(in));
        this.hasAggs = in.readBoolean();
        if (this.hasAggs) {
            this.aggregations = InternalAggregations.readAggregations(in);
        }
        this.pipelineAggregators = in.readNamedWriteableList(PipelineAggregator.class).stream().map(a -> (SiblingPipelineAggregator)a).collect(Collectors.toList());
        if (in.readBoolean()) {
            this.suggest = Suggest.readSuggest(in);
        }
        this.searchTimedOut = in.readBoolean();
        this.terminatedEarly = in.readOptionalBoolean();
        this.profileShardResults = in.readOptionalWriteable(ProfileShardResult::new);
        this.hasProfileResults = this.profileShardResults != null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.requestId);
        this.writeToNoId(out);
    }

    public void writeToNoId(StreamOutput out) throws IOException {
        out.writeVInt(this.from);
        out.writeVInt(this.size);
        if (this.sortValueFormats == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(1 + this.sortValueFormats.length);
            for (int i = 0; i < this.sortValueFormats.length; ++i) {
                out.writeNamedWriteable(this.sortValueFormats[i]);
            }
        }
        Lucene.writeTopDocs(out, this.topDocs);
        if (this.aggregations == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.aggregations.writeTo(out);
        }
        out.writeNamedWriteableList(this.pipelineAggregators == null ? Collections.emptyList() : this.pipelineAggregators);
        if (this.suggest == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.suggest.writeTo(out);
        }
        out.writeBoolean(this.searchTimedOut);
        out.writeOptionalBoolean(this.terminatedEarly);
        out.writeOptionalWriteable(this.profileShardResults);
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public float getMaxScore() {
        return this.maxScore;
    }
}

