/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import io.searchbox.client.JestClient;
import io.searchbox.core.MultiSearch;
import io.searchbox.core.MultiSearchResult;
import io.searchbox.core.Search;
import java.util.List;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.counts.CountsAdapter;

public class CountsAdapterES6
implements CountsAdapter {
    private final JestClient jestClient;

    @Inject
    public CountsAdapterES6(JestClient jestClient) {
        this.jestClient = jestClient;
    }

    public long totalCount(List<String> indices) {
        String query = new SearchSourceBuilder().query(QueryBuilders.matchAllQuery()).size(0).toString();
        Search request = ((Search.Builder)new Search.Builder(query).addIndex(indices)).build();
        MultiSearch multiSearch = new MultiSearch.Builder(request).build();
        MultiSearchResult searchResult = JestUtils.execute(this.jestClient, multiSearch, () -> "Fetching message count failed for indices " + indices);
        List<MultiSearchResult.MultiSearchResponse> responses = searchResult.getResponses();
        long total = 0L;
        for (MultiSearchResult.MultiSearchResponse response : responses) {
            if (response.isError) {
                throw JestUtils.specificException(() -> "Fetching message count failed for indices " + indices, response.error);
            }
            total += response.searchResult.getTotal().longValue();
        }
        return total;
    }
}

