/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.primitives.Ints;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.cluster.Health;
import io.searchbox.cluster.State;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.Cat;
import io.searchbox.core.CatResult;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.SearchScroll;
import io.searchbox.core.search.aggregation.FilterAggregation;
import io.searchbox.core.search.aggregation.MaxAggregation;
import io.searchbox.core.search.aggregation.MinAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import io.searchbox.indices.CloseIndex;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.Flush;
import io.searchbox.indices.ForceMerge;
import io.searchbox.indices.OpenIndex;
import io.searchbox.indices.Stats;
import io.searchbox.indices.aliases.AddAliasMapping;
import io.searchbox.indices.aliases.GetAliases;
import io.searchbox.indices.aliases.ModifyAliases;
import io.searchbox.indices.aliases.RemoveAliasMapping;
import io.searchbox.indices.mapping.PutMapping;
import io.searchbox.indices.settings.GetSettings;
import io.searchbox.indices.settings.UpdateSettings;
import io.searchbox.indices.template.DeleteTemplate;
import io.searchbox.indices.template.PutTemplate;
import io.searchbox.params.SearchType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.http.client.config.RequestConfig;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch5.org.elasticsearch.search.sort.SortBuilders;
import org.graylog.storage.elasticsearch6.IndexingHelper;
import org.graylog.storage.elasticsearch6.indices.GetSingleAlias;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.IndexNotFoundException;
import org.graylog2.indexer.indices.HealthStatus;
import org.graylog2.indexer.indices.IndexMoveResult;
import org.graylog2.indexer.indices.IndexSettings;
import org.graylog2.indexer.indices.IndicesAdapter;
import org.graylog2.indexer.indices.stats.IndexStatistics;
import org.graylog2.indexer.searches.IndexRangeStats;
import org.graylog2.jackson.TypeReferences;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndicesAdapterES6
implements IndicesAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(IndicesAdapterES6.class);
    private final JestClient jestClient;
    private final ObjectMapper objectMapper;
    private final IndexingHelper indexingHelper;

    @Inject
    public IndicesAdapterES6(JestClient jestClient, ObjectMapper objectMapper, IndexingHelper indexingHelper) {
        this.jestClient = jestClient;
        this.objectMapper = objectMapper;
        this.indexingHelper = indexingHelper;
    }

    public void move(String source, String target, Consumer<IndexMoveResult> resultCallback) {
        SearchScroll scrollRequest;
        JestResult scrollResult;
        JsonNode scrollHits;
        String query = SearchSourceBuilder.searchSource().query(QueryBuilders.matchAllQuery()).size(350).sort(SortBuilders.fieldSort("_doc")).toString();
        Search request = ((Search.Builder)((Search.Builder)new Search.Builder(query).setParameter("scroll", "10s")).addIndex(source)).build();
        SearchResult searchResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't process search query response");
        String scrollId = searchResult.getJsonObject().path("_scroll_id").asText(null);
        if (scrollId == null) {
            throw new ElasticsearchException("Couldn't find scroll ID in search query response");
        }
        while ((scrollHits = (scrollResult = JestUtils.execute(this.jestClient, scrollRequest = new SearchScroll.Builder(scrollId, "1m").build(), () -> "Couldn't process result of scroll query")).getJsonObject().path("hits").path("hits")).size() != 0) {
            Bulk.Builder bulkRequestBuilder = new Bulk.Builder();
            for (JsonNode jsonElement : scrollHits) {
                Optional.ofNullable(jsonElement.path("_source")).map(sourceJson -> (Map)this.objectMapper.convertValue(sourceJson, TypeReferences.MAP_STRING_OBJECT)).ifPresent(doc -> {
                    String id = (String)doc.remove("_id");
                    if (!Strings.isNullOrEmpty((String)id)) {
                        bulkRequestBuilder.addAction(this.indexingHelper.prepareIndexRequest(target, (Map<String, Object>)doc, id));
                    }
                });
            }
            BulkResult bulkResult = JestUtils.execute(this.jestClient, bulkRequestBuilder.build(), () -> "Couldn't bulk index messages into index " + target);
            boolean hasFailedItems = !bulkResult.getFailedItems().isEmpty();
            IndexMoveResult result = IndexMoveResult.create((int)bulkResult.getItems().size(), (long)bulkResult.getJsonObject().path("took").asLong(), (boolean)hasFailedItems);
            resultCallback.accept(result);
        }
    }

    public void delete(String indexName) {
        JestUtils.execute(this.jestClient, new DeleteIndex.Builder(indexName).build(), () -> "Couldn't delete index " + indexName);
    }

    public Set<String> resolveAlias(String alias) {
        GetSingleAlias request = new GetSingleAlias.Builder().alias(this.uncheckedURLEncode(alias)).build();
        try {
            JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't collect indices for alias " + alias);
            return ImmutableSet.copyOf((Iterator)jestResult.getJsonObject().fieldNames());
        }
        catch (ElasticsearchException e) {
            if (e.getMessage().startsWith("Couldn't collect indices for alias ")) {
                return Collections.emptySet();
            }
            throw e;
        }
    }

    public void create(String indexName, IndexSettings indexSettings, String templateName, Map<String, Object> template) {
        JestResult jestResult;
        HashMap<String, Integer> settings = new HashMap<String, Integer>();
        settings.put("number_of_shards", indexSettings.shards());
        settings.put("number_of_replicas", indexSettings.replicas());
        CreateIndex request = new CreateIndex.Builder(indexName).settings(settings).build();
        try {
            jestResult = this.jestClient.execute(request);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't create index " + indexName, (Throwable)e);
        }
        if (!jestResult.isSucceeded()) {
            throw new ElasticsearchException(jestResult.getErrorMessage());
        }
    }

    public void updateIndexMapping(@Nonnull String indexName, @Nonnull String mappingType, @Nonnull Map<String, Object> mapping) {
        JestResult jestResult;
        PutMapping request = new PutMapping.Builder(indexName, mappingType, mapping).build();
        try {
            jestResult = this.jestClient.execute(request);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Couldn't update index mapping " + indexName + "/" + mappingType, (Throwable)e);
        }
        if (!jestResult.isSucceeded()) {
            throw new ElasticsearchException(jestResult.getErrorMessage());
        }
    }

    public boolean ensureIndexTemplate(String templateName, Map<String, Object> template) {
        PutTemplate request = new PutTemplate.Builder(this.uncheckedURLEncode(templateName), template).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Unable to create index template " + templateName);
        return jestResult.isSucceeded();
    }

    private String uncheckedURLEncode(String templateName) {
        try {
            return URLEncoder.encode(templateName, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<DateTime> indexCreationDate(String index) {
        GetSettings request = ((GetSettings.Builder)((GetSettings.Builder)new GetSettings.Builder().addIndex(index)).ignoreUnavailable(true)).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read settings of index " + index);
        return Optional.of(jestResult.getJsonObject().path(index).path("settings").path("index").path("creation_date")).filter(JsonNode::isValueNode).map(JsonNode::asLong).map(creationDate -> new DateTime(creationDate, DateTimeZone.UTC));
    }

    public void openIndex(String index) {
        JestUtils.execute(this.jestClient, new OpenIndex.Builder(index).build(), () -> "Couldn't open index " + index);
    }

    public void setReadOnly(String index) {
        ImmutableMap settings = ImmutableMap.of((Object)"index", (Object)ImmutableMap.of((Object)"blocks", (Object)ImmutableMap.of((Object)"write", (Object)true, (Object)"read", (Object)false, (Object)"metadata", (Object)false)));
        UpdateSettings request = ((UpdateSettings.Builder)new UpdateSettings.Builder(settings).addIndex(index)).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't set index " + index + " to read-only");
    }

    public void flush(String index) {
        JestUtils.execute(this.jestClient, ((Flush.Builder)new Flush.Builder().addIndex(index)).force().build(), () -> "Couldn't flush index " + index);
    }

    public void markIndexReopened(String index) {
        String aliasName = index + "_reopened";
        ModifyAliases request = new ModifyAliases.Builder(new AddAliasMapping.Builder(index, aliasName).build()).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't create reopened alias for index " + index);
    }

    public void removeAlias(String indexName, String alias) {
        JestUtils.execute(this.jestClient, new ModifyAliases.Builder(new RemoveAliasMapping.Builder(indexName, alias).build()).build(), () -> "Couldn't remove reopened alias for index " + indexName + " before closing.");
    }

    public void removeAliases(Set<String> indices, String alias) {
        RemoveAliasMapping removeAliasMapping = new RemoveAliasMapping.Builder((List<String>)ImmutableList.copyOf(indices), alias).build();
        ModifyAliases request = new ModifyAliases.Builder(removeAliasMapping).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't remove alias " + alias + " from indices " + indices);
    }

    public void optimizeIndex(String index, int maxNumSegments, Duration timeout) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(Ints.saturatedCast((long)timeout.toMilliseconds())).build();
        ForceMerge request = ((ForceMerge.Builder)new ForceMerge.Builder().addIndex(index)).maxNumSegments(maxNumSegments).flush(true).onlyExpungeDeletes(false).build();
        JestUtils.execute(this.jestClient, requestConfig, request, () -> "Couldn't force merge index " + index);
    }

    public IndexRangeStats indexRangeStatsOfIndex(String index) {
        SearchResult result;
        FilterAggregation f;
        FilterAggregationBuilder builder = (FilterAggregationBuilder)((FilterAggregationBuilder)((FilterAggregationBuilder)AggregationBuilders.filter("agg", QueryBuilders.existsQuery("timestamp")).subAggregation((AggregationBuilder)AggregationBuilders.min("ts_min").field("timestamp"))).subAggregation((AggregationBuilder)AggregationBuilders.max("ts_max").field("timestamp"))).subAggregation((AggregationBuilder)AggregationBuilders.terms("streams").size(Integer.MAX_VALUE).field("streams"));
        String query = SearchSourceBuilder.searchSource().aggregation(builder).size(0).toString();
        Search request = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(index)).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).ignoreUnavailable(true)).build();
        if (LOG.isDebugEnabled()) {
            String data = "{}";
            try {
                data = request.getData(this.objectMapper.copy().enable(SerializationFeature.INDENT_OUTPUT));
            }
            catch (IOException e) {
                LOG.debug("Couldn't pretty print request payload", (Throwable)e);
            }
            LOG.debug("Index range query: _search/{}: {}", (Object)index, (Object)data);
        }
        if ((f = (result = JestUtils.execute(this.jestClient, request, () -> "Couldn't build index range of index " + index)).getAggregations().getFilterAggregation("agg")) == null) {
            throw new IndexNotFoundException("Couldn't build index range of index " + index + " because it doesn't exist.");
        }
        if (f.getCount() == 0L) {
            LOG.debug("No documents with attribute \"timestamp\" found in index <{}>", (Object)index);
            return IndexRangeStats.EMPTY;
        }
        MinAggregation minAgg = f.getMinAggregation("ts_min");
        DateTime min = new DateTime(minAgg.getMin().longValue(), DateTimeZone.UTC);
        MaxAggregation maxAgg = f.getMaxAggregation("ts_max");
        DateTime max = new DateTime(maxAgg.getMax().longValue(), DateTimeZone.UTC);
        TermsAggregation streams = f.getTermsAggregation("streams");
        List streamIds = streams.getBuckets().stream().map(TermsAggregation.Entry::getKeyAsString).collect(Collectors.toList());
        return IndexRangeStats.create((DateTime)min, (DateTime)max, streamIds);
    }

    public HealthStatus waitForRecovery(String index) {
        return this.waitForRecovery(index, 30);
    }

    public HealthStatus waitForRecovery(String index, int timeout) {
        Health.Status status = this.waitForStatus(index, Health.Status.YELLOW, timeout);
        return this.mapHealthStatus(status);
    }

    private HealthStatus mapHealthStatus(Health.Status status) {
        return HealthStatus.fromString((String)status.toString());
    }

    private Health.Status waitForStatus(String index, Health.Status clusterHealthStatus, int timeout) {
        Health request = ((Health.Builder)new Health.Builder().addIndex(index)).waitForStatus(clusterHealthStatus).timeout(timeout).build();
        JestResult jestResult = JestUtils.executeUnsafe(this.jestClient, null, request, () -> "Couldn't read health status for index " + index);
        String status = jestResult.getJsonObject().path("status").asText();
        return Health.Status.valueOf(status.toUpperCase(Locale.ENGLISH));
    }

    private Health.Status waitForStatus(String index, Health.Status clusterHealthStatus) {
        return this.waitForStatus(index, clusterHealthStatus, 30);
    }

    public void close(String indexName) {
        JestUtils.execute(this.jestClient, new CloseIndex.Builder(indexName).build(), () -> "Couldn't close index " + indexName);
    }

    public long numberOfMessages(String indexName) {
        return this.indexStats(indexName).path("primaries").path("docs").path("count").asLong();
    }

    private JsonNode indexStats(String indexName) {
        Stats request = ((Stats.Builder)new Stats.Builder().addIndex(indexName)).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check stats of index " + indexName);
        return jestResult.getJsonObject().path("indices").path(indexName);
    }

    public boolean aliasExists(String alias) throws IOException {
        JestResult result = this.jestClient.execute(((GetSettings.Builder)new GetSettings.Builder().addIndex(alias)).build());
        return result.isSucceeded() && !Iterators.contains((Iterator)result.getJsonObject().fieldNames(), (Object)alias);
    }

    public Map<String, Set<String>> aliases(String indexPattern) {
        GetAliases request = ((GetAliases.Builder)((GetAliases.Builder)new GetAliases.Builder().addIndex(indexPattern)).setParameter("expand_wildcards", "open")).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't collect aliases for index pattern " + indexPattern);
        ImmutableMap.Builder indexAliasesBuilder = ImmutableMap.builder();
        Iterator it = jestResult.getJsonObject().fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String indexName = (String)entry.getKey();
            JsonNode aliasMetaData = ((JsonNode)entry.getValue()).path("aliases");
            if (!aliasMetaData.isObject()) continue;
            ImmutableSet aliasNames = ImmutableSet.copyOf((Iterator)aliasMetaData.fieldNames());
            indexAliasesBuilder.put((Object)indexName, (Object)aliasNames);
        }
        return indexAliasesBuilder.build();
    }

    public boolean deleteIndexTemplate(String templateName) {
        JestResult result = JestUtils.execute(this.jestClient, new DeleteTemplate.Builder(templateName).build(), () -> "Unable to delete the Graylog index template " + templateName);
        return result.isSucceeded();
    }

    public Map<String, Set<String>> fieldsInIndices(String[] writeIndexWildcards) {
        String indices = String.join((CharSequence)",", writeIndexWildcards);
        State request = new State.Builder().indices(indices).withMetadata().build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't read cluster state for indices " + indices);
        JsonNode indicesJson = this.getClusterStateIndicesMetadata(jestResult.getJsonObject());
        ImmutableMap.Builder fields = ImmutableMap.builder();
        Iterator it = indicesJson.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String indexName = (String)entry.getKey();
            ImmutableSet fieldNames = ImmutableSet.copyOf((Iterator)((JsonNode)entry.getValue()).path("mappings").path("message").path("properties").fieldNames());
            if (fieldNames.isEmpty()) continue;
            fields.put((Object)indexName, (Object)fieldNames);
        }
        return fields.build();
    }

    public Set<String> closedIndices(Collection<String> indices) {
        JsonNode catIndices = this.catIndices(indices, "index", "status");
        ImmutableSet.Builder closedIndices = ImmutableSet.builder();
        for (JsonNode jsonElement : catIndices) {
            if (!jsonElement.isObject()) continue;
            String index = jsonElement.path("index").asText(null);
            String status = jsonElement.path("status").asText(null);
            if (index == null || !"close".equals(status)) continue;
            closedIndices.add((Object)index);
        }
        return closedIndices.build();
    }

    public Set<IndexStatistics> indicesStats(Collection<String> indices) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        JsonNode allWithShardLevel = this.getAllWithShardLevel(indices);
        Iterator fields = allWithShardLevel.fields();
        while (fields.hasNext()) {
            Map.Entry entry = (Map.Entry)fields.next();
            String index = (String)entry.getKey();
            JsonNode indexStats = (JsonNode)entry.getValue();
            if (!indexStats.isObject()) continue;
            result.add((Object)this.buildIndexStatistics(index, indexStats));
        }
        return result.build();
    }

    public Optional<IndexStatistics> getIndexStats(String index) {
        JsonNode indexStats = this.indexStatsWithShardLevel(index);
        return indexStats.isMissingNode() ? Optional.empty() : Optional.of(this.buildIndexStatistics(index, indexStats));
    }

    public JsonNode getIndexStats(Collection<String> indices) {
        Stats request = ((Stats.Builder)new Stats.Builder().addIndex(indices)).docs(true).store(true).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check stats of indices " + indices);
        return jestResult.getJsonObject().path("indices");
    }

    public boolean exists(String indexName) throws IOException {
        JestResult result = this.jestClient.execute(((GetSettings.Builder)new GetSettings.Builder().addIndex(indexName)).build());
        return result.isSucceeded() && Iterators.contains((Iterator)result.getJsonObject().fieldNames(), (Object)indexName);
    }

    public Set<String> indices(String indexWildcard, List<String> status, String indexSetId) {
        Cat catRequest = ((Cat.IndicesBuilder)((Cat.IndicesBuilder)new Cat.IndicesBuilder().addIndex(indexWildcard)).setParameter("h", "index,status")).build();
        CatResult result = JestUtils.execute(this.jestClient, catRequest, () -> "Couldn't get index list for index set <" + indexSetId + ">");
        return StreamSupport.stream(result.getJsonObject().path("result").spliterator(), false).filter(cat -> status.isEmpty() || status.contains(cat.path("status").asText())).map(cat -> cat.path("index").asText()).collect(Collectors.toSet());
    }

    public Optional<Long> storeSizeInBytes(String index) {
        Stats request = ((Stats.Builder)new Stats.Builder().addIndex(index)).store(true).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check store stats of index " + index);
        JsonNode sizeInBytes = jestResult.getJsonObject().path("indices").path(index).path("primaries").path("store").path("size_in_bytes");
        return Optional.of(sizeInBytes).filter(JsonNode::isNumber).map(JsonNode::asLong);
    }

    public void cycleAlias(String aliasName, String targetIndex) {
        AddAliasMapping addAliasMapping = new AddAliasMapping.Builder(targetIndex, aliasName).build();
        JestUtils.execute(this.jestClient, new ModifyAliases.Builder(addAliasMapping).build(), () -> "Couldn't point alias " + aliasName + " to index " + targetIndex);
    }

    public void cycleAlias(String aliasName, String targetIndex, String oldIndex) {
        AddAliasMapping addAliasMapping = new AddAliasMapping.Builder(targetIndex, aliasName).build();
        RemoveAliasMapping removeAliasMapping = new RemoveAliasMapping.Builder(oldIndex, aliasName).build();
        ModifyAliases request = new ModifyAliases.Builder(Arrays.asList(removeAliasMapping, addAliasMapping)).build();
        JestUtils.execute(this.jestClient, request, () -> "Couldn't switch alias " + aliasName + " from index " + oldIndex + " to index " + targetIndex);
    }

    private JsonNode indexStatsWithShardLevel(String indexName) {
        Stats request = ((Stats.Builder)((Stats.Builder)((Stats.Builder)new Stats.Builder().addIndex(indexName)).setParameter("level", "shards")).ignoreUnavailable(true)).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't check stats of index " + indexName);
        return jestResult.getJsonObject().path("indices").path(indexName);
    }

    private JsonNode getAllWithShardLevel(Collection<String> indices) {
        Stats request = ((Stats.Builder)((Stats.Builder)new Stats.Builder().addIndex(indices)).setParameter("level", "shards")).build();
        JestResult jestResult = JestUtils.execute(this.jestClient, request, () -> "Couldn't fetch index stats of indices " + indices);
        JsonNode responseJson = jestResult.getJsonObject();
        int failedShards = responseJson.path("_shards").path("failed").asInt();
        if (failedShards > 0) {
            throw new ElasticsearchException("Index stats response contains failed shards, response is incomplete");
        }
        return responseJson.path("indices");
    }

    private IndexStatistics buildIndexStatistics(String index, JsonNode indexStats) {
        return IndexStatistics.create((String)index, (JsonNode)indexStats);
    }

    private JsonNode catIndices(Collection<String> indices, String ... fields) {
        String fieldNames = String.join((CharSequence)",", fields);
        Cat request = ((Cat.IndicesBuilder)((Cat.IndicesBuilder)new Cat.IndicesBuilder().addIndex(indices)).setParameter("h", fieldNames)).build();
        CatResult response = JestUtils.execute(this.jestClient, request, () -> "Unable to read information for indices " + indices);
        return response.getJsonObject().path("result");
    }

    private JsonNode getClusterStateIndicesMetadata(JsonNode clusterStateJson) {
        return clusterStateJson.path("metadata").path("indices");
    }

    public boolean isOpen(String index) {
        return this.getIndexState(index).equals("open");
    }

    public boolean isClosed(String index) {
        return this.getIndexState(index).equals("close");
    }

    private String getIndexState(String index) {
        State request = new State.Builder().indices(index).withMetadata().build();
        JestResult response = JestUtils.execute(this.jestClient, request, () -> "Failed to get index metadata");
        return response.getJsonObject().path("metadata").path("indices").path(index).path("state").asText();
    }
}

