/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.jest;

import com.google.common.base.Preconditions;
import io.searchbox.client.JestRetryHandler;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraylogJestRetryHandler
implements JestRetryHandler<HttpUriRequest> {
    private static final Logger log = LoggerFactory.getLogger(GraylogJestRetryHandler.class);
    private final int retryCount;
    private final Collection<Class<? extends Exception>> exceptionClasses = Arrays.asList(UnknownHostException.class, SocketException.class, SocketTimeoutException.class, ConnectionClosedException.class, SSLException.class);

    public GraylogJestRetryHandler(int retryCount) {
        Preconditions.checkArgument((retryCount >= 0 ? 1 : 0) != 0, (Object)"retryCount must be positive");
        this.retryCount = retryCount;
    }

    @Override
    public boolean retryRequest(Exception exception, int executionCount, HttpUriRequest request) {
        if (executionCount >= this.retryCount) {
            log.debug("Maximum number of retries ({}) for request {} reached (executed {} times) (Reason: {})", new Object[]{this.retryCount, request, executionCount, exception.getMessage()});
            return false;
        }
        for (Class<? extends Exception> exceptionClass : this.exceptionClasses) {
            if (!exceptionClass.isInstance(exception)) continue;
            log.debug("Retrying request {} (Reason: {})", (Object)request, (Object)exception.getMessage());
            return true;
        }
        log.debug("Not retrying request {} due to unsupported exception (Reason: {})", (Object)request, (Object)exception.getMessage());
        return false;
    }
}

