/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch6.views.export;

import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.graylog.plugins.views.search.export.ExportException;
import org.graylog.storage.elasticsearch6.jest.JestUtils;
import org.graylog2.indexer.ElasticsearchException;

public class JestWrapper {
    private final JestClient jestClient;

    @Inject
    public JestWrapper(JestClient jestClient) {
        this.jestClient = jestClient;
    }

    public <T extends JestResult> T execute(Action<T> action, Supplier<String> errorMessageSupplier) {
        T result = JestUtils.execute(this.jestClient, action, errorMessageSupplier);
        Optional<ElasticsearchException> elasticsearchException = JestUtils.checkForFailedShards(result);
        if (elasticsearchException.isPresent()) {
            throw new ExportException(errorMessageSupplier.get(), (Exception)elasticsearchException.get());
        }
        return result;
    }
}

