/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PortRange;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AnalysisPacketHeader
implements Serializable,
Cloneable {
    private SdkInternalList<String> destinationAddresses;
    private SdkInternalList<PortRange> destinationPortRanges;
    private String protocol;
    private SdkInternalList<String> sourceAddresses;
    private SdkInternalList<PortRange> sourcePortRanges;

    public List<String> getDestinationAddresses() {
        if (this.destinationAddresses == null) {
            this.destinationAddresses = new SdkInternalList();
        }
        return this.destinationAddresses;
    }

    public void setDestinationAddresses(Collection<String> destinationAddresses) {
        if (destinationAddresses == null) {
            this.destinationAddresses = null;
            return;
        }
        this.destinationAddresses = new SdkInternalList<String>(destinationAddresses);
    }

    public AnalysisPacketHeader withDestinationAddresses(String ... destinationAddresses) {
        if (this.destinationAddresses == null) {
            this.setDestinationAddresses(new SdkInternalList<String>(destinationAddresses.length));
        }
        for (String ele : destinationAddresses) {
            this.destinationAddresses.add(ele);
        }
        return this;
    }

    public AnalysisPacketHeader withDestinationAddresses(Collection<String> destinationAddresses) {
        this.setDestinationAddresses(destinationAddresses);
        return this;
    }

    public List<PortRange> getDestinationPortRanges() {
        if (this.destinationPortRanges == null) {
            this.destinationPortRanges = new SdkInternalList();
        }
        return this.destinationPortRanges;
    }

    public void setDestinationPortRanges(Collection<PortRange> destinationPortRanges) {
        if (destinationPortRanges == null) {
            this.destinationPortRanges = null;
            return;
        }
        this.destinationPortRanges = new SdkInternalList<PortRange>(destinationPortRanges);
    }

    public AnalysisPacketHeader withDestinationPortRanges(PortRange ... destinationPortRanges) {
        if (this.destinationPortRanges == null) {
            this.setDestinationPortRanges(new SdkInternalList<PortRange>(destinationPortRanges.length));
        }
        for (PortRange ele : destinationPortRanges) {
            this.destinationPortRanges.add(ele);
        }
        return this;
    }

    public AnalysisPacketHeader withDestinationPortRanges(Collection<PortRange> destinationPortRanges) {
        this.setDestinationPortRanges(destinationPortRanges);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public AnalysisPacketHeader withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public List<String> getSourceAddresses() {
        if (this.sourceAddresses == null) {
            this.sourceAddresses = new SdkInternalList();
        }
        return this.sourceAddresses;
    }

    public void setSourceAddresses(Collection<String> sourceAddresses) {
        if (sourceAddresses == null) {
            this.sourceAddresses = null;
            return;
        }
        this.sourceAddresses = new SdkInternalList<String>(sourceAddresses);
    }

    public AnalysisPacketHeader withSourceAddresses(String ... sourceAddresses) {
        if (this.sourceAddresses == null) {
            this.setSourceAddresses(new SdkInternalList<String>(sourceAddresses.length));
        }
        for (String ele : sourceAddresses) {
            this.sourceAddresses.add(ele);
        }
        return this;
    }

    public AnalysisPacketHeader withSourceAddresses(Collection<String> sourceAddresses) {
        this.setSourceAddresses(sourceAddresses);
        return this;
    }

    public List<PortRange> getSourcePortRanges() {
        if (this.sourcePortRanges == null) {
            this.sourcePortRanges = new SdkInternalList();
        }
        return this.sourcePortRanges;
    }

    public void setSourcePortRanges(Collection<PortRange> sourcePortRanges) {
        if (sourcePortRanges == null) {
            this.sourcePortRanges = null;
            return;
        }
        this.sourcePortRanges = new SdkInternalList<PortRange>(sourcePortRanges);
    }

    public AnalysisPacketHeader withSourcePortRanges(PortRange ... sourcePortRanges) {
        if (this.sourcePortRanges == null) {
            this.setSourcePortRanges(new SdkInternalList<PortRange>(sourcePortRanges.length));
        }
        for (PortRange ele : sourcePortRanges) {
            this.sourcePortRanges.add(ele);
        }
        return this;
    }

    public AnalysisPacketHeader withSourcePortRanges(Collection<PortRange> sourcePortRanges) {
        this.setSourcePortRanges(sourcePortRanges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinationAddresses() != null) {
            sb.append("DestinationAddresses: ").append(this.getDestinationAddresses()).append(",");
        }
        if (this.getDestinationPortRanges() != null) {
            sb.append("DestinationPortRanges: ").append(this.getDestinationPortRanges()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getSourceAddresses() != null) {
            sb.append("SourceAddresses: ").append(this.getSourceAddresses()).append(",");
        }
        if (this.getSourcePortRanges() != null) {
            sb.append("SourcePortRanges: ").append(this.getSourcePortRanges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisPacketHeader)) {
            return false;
        }
        AnalysisPacketHeader other = (AnalysisPacketHeader)obj;
        if (other.getDestinationAddresses() == null ^ this.getDestinationAddresses() == null) {
            return false;
        }
        if (other.getDestinationAddresses() != null && !other.getDestinationAddresses().equals(this.getDestinationAddresses())) {
            return false;
        }
        if (other.getDestinationPortRanges() == null ^ this.getDestinationPortRanges() == null) {
            return false;
        }
        if (other.getDestinationPortRanges() != null && !other.getDestinationPortRanges().equals(this.getDestinationPortRanges())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getSourceAddresses() == null ^ this.getSourceAddresses() == null) {
            return false;
        }
        if (other.getSourceAddresses() != null && !other.getSourceAddresses().equals(this.getSourceAddresses())) {
            return false;
        }
        if (other.getSourcePortRanges() == null ^ this.getSourcePortRanges() == null) {
            return false;
        }
        return other.getSourcePortRanges() == null || other.getSourcePortRanges().equals(this.getSourcePortRanges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinationAddresses() == null ? 0 : this.getDestinationAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPortRanges() == null ? 0 : this.getDestinationPortRanges().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getSourceAddresses() == null ? 0 : this.getSourceAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePortRanges() == null ? 0 : this.getSourcePortRanges().hashCode());
        return hashCode;
    }

    public AnalysisPacketHeader clone() {
        try {
            return (AnalysisPacketHeader)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

