/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CopySnapshotRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CopySnapshotRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CopySnapshotRequest> {
    private String description;
    private String destinationRegion;
    private Boolean encrypted;
    private String kmsKeyId;
    private String presignedUrl;
    private String sourceRegion;
    private String sourceSnapshotId;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CopySnapshotRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setDestinationRegion(String destinationRegion) {
        this.destinationRegion = destinationRegion;
    }

    public String getDestinationRegion() {
        return this.destinationRegion;
    }

    public CopySnapshotRequest withDestinationRegion(String destinationRegion) {
        this.setDestinationRegion(destinationRegion);
        return this;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public CopySnapshotRequest withEncrypted(Boolean encrypted) {
        this.setEncrypted(encrypted);
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CopySnapshotRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setPresignedUrl(String presignedUrl) {
        this.presignedUrl = presignedUrl;
    }

    public String getPresignedUrl() {
        return this.presignedUrl;
    }

    public CopySnapshotRequest withPresignedUrl(String presignedUrl) {
        this.setPresignedUrl(presignedUrl);
        return this;
    }

    public void setSourceRegion(String sourceRegion) {
        this.sourceRegion = sourceRegion;
    }

    public String getSourceRegion() {
        return this.sourceRegion;
    }

    public CopySnapshotRequest withSourceRegion(String sourceRegion) {
        this.setSourceRegion(sourceRegion);
        return this;
    }

    public void setSourceSnapshotId(String sourceSnapshotId) {
        this.sourceSnapshotId = sourceSnapshotId;
    }

    public String getSourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public CopySnapshotRequest withSourceSnapshotId(String sourceSnapshotId) {
        this.setSourceSnapshotId(sourceSnapshotId);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CopySnapshotRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CopySnapshotRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CopySnapshotRequest> getDryRunRequest() {
        Request<CopySnapshotRequest> request = new CopySnapshotRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getDestinationRegion() != null) {
            sb.append("DestinationRegion: ").append(this.getDestinationRegion()).append(",");
        }
        if (this.getEncrypted() != null) {
            sb.append("Encrypted: ").append(this.getEncrypted()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getPresignedUrl() != null) {
            sb.append("PresignedUrl: ").append(this.getPresignedUrl()).append(",");
        }
        if (this.getSourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.getSourceRegion()).append(",");
        }
        if (this.getSourceSnapshotId() != null) {
            sb.append("SourceSnapshotId: ").append(this.getSourceSnapshotId()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getDestinationRegion() == null ^ this.getDestinationRegion() == null) {
            return false;
        }
        if (other.getDestinationRegion() != null && !other.getDestinationRegion().equals(this.getDestinationRegion())) {
            return false;
        }
        if (other.getEncrypted() == null ^ this.getEncrypted() == null) {
            return false;
        }
        if (other.getEncrypted() != null && !other.getEncrypted().equals(this.getEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getPresignedUrl() == null ^ this.getPresignedUrl() == null) {
            return false;
        }
        if (other.getPresignedUrl() != null && !other.getPresignedUrl().equals(this.getPresignedUrl())) {
            return false;
        }
        if (other.getSourceRegion() == null ^ this.getSourceRegion() == null) {
            return false;
        }
        if (other.getSourceRegion() != null && !other.getSourceRegion().equals(this.getSourceRegion())) {
            return false;
        }
        if (other.getSourceSnapshotId() == null ^ this.getSourceSnapshotId() == null) {
            return false;
        }
        if (other.getSourceSnapshotId() != null && !other.getSourceSnapshotId().equals(this.getSourceSnapshotId())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationRegion() == null ? 0 : this.getDestinationRegion().hashCode());
        hashCode = 31 * hashCode + (this.getEncrypted() == null ? 0 : this.getEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getPresignedUrl() == null ? 0 : this.getPresignedUrl().hashCode());
        hashCode = 31 * hashCode + (this.getSourceRegion() == null ? 0 : this.getSourceRegion().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSnapshotId() == null ? 0 : this.getSourceSnapshotId().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public CopySnapshotRequest clone() {
        return (CopySnapshotRequest)super.clone();
    }
}

