/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateNatGatewayRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateNatGatewayRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateNatGatewayRequest> {
    private String allocationId;
    private String clientToken;
    private String subnetId;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public void setAllocationId(String allocationId) {
        this.allocationId = allocationId;
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public CreateNatGatewayRequest withAllocationId(String allocationId) {
        this.setAllocationId(allocationId);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateNatGatewayRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public CreateNatGatewayRequest withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList<TagSpecification>(tagSpecifications);
    }

    public CreateNatGatewayRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications(new SdkInternalList<TagSpecification>(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add(ele);
        }
        return this;
    }

    public CreateNatGatewayRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateNatGatewayRequest> getDryRunRequest() {
        Request<CreateNatGatewayRequest> request = new CreateNatGatewayRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocationId() != null) {
            sb.append("AllocationId: ").append(this.getAllocationId()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNatGatewayRequest)) {
            return false;
        }
        CreateNatGatewayRequest other = (CreateNatGatewayRequest)obj;
        if (other.getAllocationId() == null ^ this.getAllocationId() == null) {
            return false;
        }
        if (other.getAllocationId() != null && !other.getAllocationId().equals(this.getAllocationId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocationId() == null ? 0 : this.getAllocationId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public CreateNatGatewayRequest clone() {
        return (CreateNatGatewayRequest)super.clone();
    }
}

