/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeNetworkAclsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeNetworkAclsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeNetworkAclsRequest> {
    private SdkInternalList<Filter> filters;
    private SdkInternalList<String> networkAclIds;
    private String nextToken;
    private Integer maxResults;

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<Filter>(filters);
    }

    public DescribeNetworkAclsRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeNetworkAclsRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getNetworkAclIds() {
        if (this.networkAclIds == null) {
            this.networkAclIds = new SdkInternalList();
        }
        return this.networkAclIds;
    }

    public void setNetworkAclIds(Collection<String> networkAclIds) {
        if (networkAclIds == null) {
            this.networkAclIds = null;
            return;
        }
        this.networkAclIds = new SdkInternalList<String>(networkAclIds);
    }

    public DescribeNetworkAclsRequest withNetworkAclIds(String ... networkAclIds) {
        if (this.networkAclIds == null) {
            this.setNetworkAclIds(new SdkInternalList<String>(networkAclIds.length));
        }
        for (String ele : networkAclIds) {
            this.networkAclIds.add(ele);
        }
        return this;
    }

    public DescribeNetworkAclsRequest withNetworkAclIds(Collection<String> networkAclIds) {
        this.setNetworkAclIds(networkAclIds);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeNetworkAclsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeNetworkAclsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    @Override
    public Request<DescribeNetworkAclsRequest> getDryRunRequest() {
        Request<DescribeNetworkAclsRequest> request = new DescribeNetworkAclsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNetworkAclIds() != null) {
            sb.append("NetworkAclIds: ").append(this.getNetworkAclIds()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsRequest)) {
            return false;
        }
        DescribeNetworkAclsRequest other = (DescribeNetworkAclsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNetworkAclIds() == null ^ this.getNetworkAclIds() == null) {
            return false;
        }
        if (other.getNetworkAclIds() != null && !other.getNetworkAclIds().equals(this.getNetworkAclIds())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkAclIds() == null ? 0 : this.getNetworkAclIds().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public DescribeNetworkAclsRequest clone() {
        return (DescribeNetworkAclsRequest)super.clone();
    }
}

