/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.GpuDeviceInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GpuInfo
implements Serializable,
Cloneable {
    private SdkInternalList<GpuDeviceInfo> gpus;
    private Integer totalGpuMemoryInMiB;

    public List<GpuDeviceInfo> getGpus() {
        if (this.gpus == null) {
            this.gpus = new SdkInternalList();
        }
        return this.gpus;
    }

    public void setGpus(Collection<GpuDeviceInfo> gpus) {
        if (gpus == null) {
            this.gpus = null;
            return;
        }
        this.gpus = new SdkInternalList<GpuDeviceInfo>(gpus);
    }

    public GpuInfo withGpus(GpuDeviceInfo ... gpus) {
        if (this.gpus == null) {
            this.setGpus(new SdkInternalList<GpuDeviceInfo>(gpus.length));
        }
        for (GpuDeviceInfo ele : gpus) {
            this.gpus.add(ele);
        }
        return this;
    }

    public GpuInfo withGpus(Collection<GpuDeviceInfo> gpus) {
        this.setGpus(gpus);
        return this;
    }

    public void setTotalGpuMemoryInMiB(Integer totalGpuMemoryInMiB) {
        this.totalGpuMemoryInMiB = totalGpuMemoryInMiB;
    }

    public Integer getTotalGpuMemoryInMiB() {
        return this.totalGpuMemoryInMiB;
    }

    public GpuInfo withTotalGpuMemoryInMiB(Integer totalGpuMemoryInMiB) {
        this.setTotalGpuMemoryInMiB(totalGpuMemoryInMiB);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGpus() != null) {
            sb.append("Gpus: ").append(this.getGpus()).append(",");
        }
        if (this.getTotalGpuMemoryInMiB() != null) {
            sb.append("TotalGpuMemoryInMiB: ").append(this.getTotalGpuMemoryInMiB());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuInfo)) {
            return false;
        }
        GpuInfo other = (GpuInfo)obj;
        if (other.getGpus() == null ^ this.getGpus() == null) {
            return false;
        }
        if (other.getGpus() != null && !other.getGpus().equals(this.getGpus())) {
            return false;
        }
        if (other.getTotalGpuMemoryInMiB() == null ^ this.getTotalGpuMemoryInMiB() == null) {
            return false;
        }
        return other.getTotalGpuMemoryInMiB() == null || other.getTotalGpuMemoryInMiB().equals(this.getTotalGpuMemoryInMiB());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGpus() == null ? 0 : this.getGpus().hashCode());
        hashCode = 31 * hashCode + (this.getTotalGpuMemoryInMiB() == null ? 0 : this.getTotalGpuMemoryInMiB().hashCode());
        return hashCode;
    }

    public GpuInfo clone() {
        try {
            return (GpuInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

