/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PlacementGroupStrategy;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PlacementGroupInfo
implements Serializable,
Cloneable {
    private SdkInternalList<String> supportedStrategies;

    public List<String> getSupportedStrategies() {
        if (this.supportedStrategies == null) {
            this.supportedStrategies = new SdkInternalList();
        }
        return this.supportedStrategies;
    }

    public void setSupportedStrategies(Collection<String> supportedStrategies) {
        if (supportedStrategies == null) {
            this.supportedStrategies = null;
            return;
        }
        this.supportedStrategies = new SdkInternalList<String>(supportedStrategies);
    }

    public PlacementGroupInfo withSupportedStrategies(String ... supportedStrategies) {
        if (this.supportedStrategies == null) {
            this.setSupportedStrategies(new SdkInternalList<String>(supportedStrategies.length));
        }
        for (String ele : supportedStrategies) {
            this.supportedStrategies.add(ele);
        }
        return this;
    }

    public PlacementGroupInfo withSupportedStrategies(Collection<String> supportedStrategies) {
        this.setSupportedStrategies(supportedStrategies);
        return this;
    }

    public PlacementGroupInfo withSupportedStrategies(PlacementGroupStrategy ... supportedStrategies) {
        SdkInternalList<String> supportedStrategiesCopy = new SdkInternalList<String>(supportedStrategies.length);
        for (PlacementGroupStrategy value : supportedStrategies) {
            supportedStrategiesCopy.add(value.toString());
        }
        if (this.getSupportedStrategies() == null) {
            this.setSupportedStrategies(supportedStrategiesCopy);
        } else {
            this.getSupportedStrategies().addAll(supportedStrategiesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSupportedStrategies() != null) {
            sb.append("SupportedStrategies: ").append(this.getSupportedStrategies());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroupInfo)) {
            return false;
        }
        PlacementGroupInfo other = (PlacementGroupInfo)obj;
        if (other.getSupportedStrategies() == null ^ this.getSupportedStrategies() == null) {
            return false;
        }
        return other.getSupportedStrategies() == null || other.getSupportedStrategies().equals(this.getSupportedStrategies());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSupportedStrategies() == null ? 0 : this.getSupportedStrategies().hashCode());
        return hashCode;
    }

    public PlacementGroupInfo clone() {
        try {
            return (PlacementGroupInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

