/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CidrAuthorizationContext;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.ProvisionByoipCidrRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ProvisionByoipCidrRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ProvisionByoipCidrRequest> {
    private String cidr;
    private CidrAuthorizationContext cidrAuthorizationContext;
    private Boolean publiclyAdvertisable;
    private String description;
    private SdkInternalList<TagSpecification> poolTagSpecifications;

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public String getCidr() {
        return this.cidr;
    }

    public ProvisionByoipCidrRequest withCidr(String cidr) {
        this.setCidr(cidr);
        return this;
    }

    public void setCidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext) {
        this.cidrAuthorizationContext = cidrAuthorizationContext;
    }

    public CidrAuthorizationContext getCidrAuthorizationContext() {
        return this.cidrAuthorizationContext;
    }

    public ProvisionByoipCidrRequest withCidrAuthorizationContext(CidrAuthorizationContext cidrAuthorizationContext) {
        this.setCidrAuthorizationContext(cidrAuthorizationContext);
        return this;
    }

    public void setPubliclyAdvertisable(Boolean publiclyAdvertisable) {
        this.publiclyAdvertisable = publiclyAdvertisable;
    }

    public Boolean getPubliclyAdvertisable() {
        return this.publiclyAdvertisable;
    }

    public ProvisionByoipCidrRequest withPubliclyAdvertisable(Boolean publiclyAdvertisable) {
        this.setPubliclyAdvertisable(publiclyAdvertisable);
        return this;
    }

    public Boolean isPubliclyAdvertisable() {
        return this.publiclyAdvertisable;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ProvisionByoipCidrRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<TagSpecification> getPoolTagSpecifications() {
        if (this.poolTagSpecifications == null) {
            this.poolTagSpecifications = new SdkInternalList();
        }
        return this.poolTagSpecifications;
    }

    public void setPoolTagSpecifications(Collection<TagSpecification> poolTagSpecifications) {
        if (poolTagSpecifications == null) {
            this.poolTagSpecifications = null;
            return;
        }
        this.poolTagSpecifications = new SdkInternalList<TagSpecification>(poolTagSpecifications);
    }

    public ProvisionByoipCidrRequest withPoolTagSpecifications(TagSpecification ... poolTagSpecifications) {
        if (this.poolTagSpecifications == null) {
            this.setPoolTagSpecifications(new SdkInternalList<TagSpecification>(poolTagSpecifications.length));
        }
        for (TagSpecification ele : poolTagSpecifications) {
            this.poolTagSpecifications.add(ele);
        }
        return this;
    }

    public ProvisionByoipCidrRequest withPoolTagSpecifications(Collection<TagSpecification> poolTagSpecifications) {
        this.setPoolTagSpecifications(poolTagSpecifications);
        return this;
    }

    @Override
    public Request<ProvisionByoipCidrRequest> getDryRunRequest() {
        Request<ProvisionByoipCidrRequest> request = new ProvisionByoipCidrRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCidr() != null) {
            sb.append("Cidr: ").append(this.getCidr()).append(",");
        }
        if (this.getCidrAuthorizationContext() != null) {
            sb.append("CidrAuthorizationContext: ").append(this.getCidrAuthorizationContext()).append(",");
        }
        if (this.getPubliclyAdvertisable() != null) {
            sb.append("PubliclyAdvertisable: ").append(this.getPubliclyAdvertisable()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPoolTagSpecifications() != null) {
            sb.append("PoolTagSpecifications: ").append(this.getPoolTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionByoipCidrRequest)) {
            return false;
        }
        ProvisionByoipCidrRequest other = (ProvisionByoipCidrRequest)obj;
        if (other.getCidr() == null ^ this.getCidr() == null) {
            return false;
        }
        if (other.getCidr() != null && !other.getCidr().equals(this.getCidr())) {
            return false;
        }
        if (other.getCidrAuthorizationContext() == null ^ this.getCidrAuthorizationContext() == null) {
            return false;
        }
        if (other.getCidrAuthorizationContext() != null && !other.getCidrAuthorizationContext().equals(this.getCidrAuthorizationContext())) {
            return false;
        }
        if (other.getPubliclyAdvertisable() == null ^ this.getPubliclyAdvertisable() == null) {
            return false;
        }
        if (other.getPubliclyAdvertisable() != null && !other.getPubliclyAdvertisable().equals(this.getPubliclyAdvertisable())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPoolTagSpecifications() == null ^ this.getPoolTagSpecifications() == null) {
            return false;
        }
        return other.getPoolTagSpecifications() == null || other.getPoolTagSpecifications().equals(this.getPoolTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCidr() == null ? 0 : this.getCidr().hashCode());
        hashCode = 31 * hashCode + (this.getCidrAuthorizationContext() == null ? 0 : this.getCidrAuthorizationContext().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAdvertisable() == null ? 0 : this.getPubliclyAdvertisable().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPoolTagSpecifications() == null ? 0 : this.getPoolTagSpecifications().hashCode());
        return hashCode;
    }

    @Override
    public ProvisionByoipCidrRequest clone() {
        return (ProvisionByoipCidrRequest)super.clone();
    }
}

