/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeAvailabilityZonesRequestMarshaller
implements Marshaller<Request<DescribeAvailabilityZonesRequest>, DescribeAvailabilityZonesRequest> {
    @Override
    public Request<DescribeAvailabilityZonesRequest> marshall(DescribeAvailabilityZonesRequest describeAvailabilityZonesRequest) {
        SdkInternalList describeAvailabilityZonesRequestZoneIdsList;
        SdkInternalList describeAvailabilityZonesRequestZoneNamesList;
        if (describeAvailabilityZonesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeAvailabilityZonesRequest> request = new DefaultRequest<DescribeAvailabilityZonesRequest>(describeAvailabilityZonesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeAvailabilityZones");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeAvailabilityZonesRequestFiltersList = (SdkInternalList)describeAvailabilityZonesRequest.getFilters();
        if (!describeAvailabilityZonesRequestFiltersList.isEmpty() || !describeAvailabilityZonesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeAvailabilityZonesRequestFiltersListValue : describeAvailabilityZonesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeAvailabilityZonesRequestFiltersListValue).getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(((Filter)describeAvailabilityZonesRequestFiltersListValue).getName()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeAvailabilityZonesRequestFiltersListValue).getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeAvailabilityZonesRequestZoneNamesList = (SdkInternalList)describeAvailabilityZonesRequest.getZoneNames()).isEmpty() || !describeAvailabilityZonesRequestZoneNamesList.isAutoConstruct()) {
            int zoneNamesListIndex = 1;
            for (String describeAvailabilityZonesRequestZoneNamesListValue : describeAvailabilityZonesRequestZoneNamesList) {
                if (describeAvailabilityZonesRequestZoneNamesListValue != null) {
                    request.addParameter("ZoneName." + zoneNamesListIndex, StringUtils.fromString(describeAvailabilityZonesRequestZoneNamesListValue));
                }
                ++zoneNamesListIndex;
            }
        }
        if (!(describeAvailabilityZonesRequestZoneIdsList = (SdkInternalList)describeAvailabilityZonesRequest.getZoneIds()).isEmpty() || !describeAvailabilityZonesRequestZoneIdsList.isAutoConstruct()) {
            int zoneIdsListIndex = 1;
            for (String describeAvailabilityZonesRequestZoneIdsListValue : describeAvailabilityZonesRequestZoneIdsList) {
                if (describeAvailabilityZonesRequestZoneIdsListValue != null) {
                    request.addParameter("ZoneId." + zoneIdsListIndex, StringUtils.fromString(describeAvailabilityZonesRequestZoneIdsListValue));
                }
                ++zoneIdsListIndex;
            }
        }
        if (describeAvailabilityZonesRequest.getAllAvailabilityZones() != null) {
            request.addParameter("AllAvailabilityZones", StringUtils.fromBoolean(describeAvailabilityZonesRequest.getAllAvailabilityZones()));
        }
        return request;
    }
}

