/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeCapacityReservationsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeCapacityReservationsRequestMarshaller
implements Marshaller<Request<DescribeCapacityReservationsRequest>, DescribeCapacityReservationsRequest> {
    @Override
    public Request<DescribeCapacityReservationsRequest> marshall(DescribeCapacityReservationsRequest describeCapacityReservationsRequest) {
        SdkInternalList describeCapacityReservationsRequestFiltersList;
        if (describeCapacityReservationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCapacityReservationsRequest> request = new DefaultRequest<DescribeCapacityReservationsRequest>(describeCapacityReservationsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeCapacityReservations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeCapacityReservationsRequestCapacityReservationIdsList = (SdkInternalList)describeCapacityReservationsRequest.getCapacityReservationIds();
        if (!describeCapacityReservationsRequestCapacityReservationIdsList.isEmpty() || !describeCapacityReservationsRequestCapacityReservationIdsList.isAutoConstruct()) {
            int capacityReservationIdsListIndex = 1;
            for (String describeCapacityReservationsRequestCapacityReservationIdsListValue : describeCapacityReservationsRequestCapacityReservationIdsList) {
                if (describeCapacityReservationsRequestCapacityReservationIdsListValue != null) {
                    request.addParameter("CapacityReservationId." + capacityReservationIdsListIndex, StringUtils.fromString(describeCapacityReservationsRequestCapacityReservationIdsListValue));
                }
                ++capacityReservationIdsListIndex;
            }
        }
        if (describeCapacityReservationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeCapacityReservationsRequest.getNextToken()));
        }
        if (describeCapacityReservationsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeCapacityReservationsRequest.getMaxResults()));
        }
        if (!(describeCapacityReservationsRequestFiltersList = (SdkInternalList)describeCapacityReservationsRequest.getFilters()).isEmpty() || !describeCapacityReservationsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeCapacityReservationsRequestFiltersListValue : describeCapacityReservationsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeCapacityReservationsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeCapacityReservationsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeCapacityReservationsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

