/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeClientVpnRoutesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeClientVpnRoutesRequestMarshaller
implements Marshaller<Request<DescribeClientVpnRoutesRequest>, DescribeClientVpnRoutesRequest> {
    @Override
    public Request<DescribeClientVpnRoutesRequest> marshall(DescribeClientVpnRoutesRequest describeClientVpnRoutesRequest) {
        SdkInternalList describeClientVpnRoutesRequestFiltersList;
        if (describeClientVpnRoutesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeClientVpnRoutesRequest> request = new DefaultRequest<DescribeClientVpnRoutesRequest>(describeClientVpnRoutesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeClientVpnRoutes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClientVpnRoutesRequest.getClientVpnEndpointId() != null) {
            request.addParameter("ClientVpnEndpointId", StringUtils.fromString(describeClientVpnRoutesRequest.getClientVpnEndpointId()));
        }
        if (!(describeClientVpnRoutesRequestFiltersList = (SdkInternalList)describeClientVpnRoutesRequest.getFilters()).isEmpty() || !describeClientVpnRoutesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeClientVpnRoutesRequestFiltersListValue : describeClientVpnRoutesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeClientVpnRoutesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeClientVpnRoutesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeClientVpnRoutesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeClientVpnRoutesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeClientVpnRoutesRequest.getMaxResults()));
        }
        if (describeClientVpnRoutesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeClientVpnRoutesRequest.getNextToken()));
        }
        return request;
    }
}

