/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeInstanceTypeOfferingsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceTypeOfferingsRequestMarshaller
implements Marshaller<Request<DescribeInstanceTypeOfferingsRequest>, DescribeInstanceTypeOfferingsRequest> {
    @Override
    public Request<DescribeInstanceTypeOfferingsRequest> marshall(DescribeInstanceTypeOfferingsRequest describeInstanceTypeOfferingsRequest) {
        SdkInternalList describeInstanceTypeOfferingsRequestFiltersList;
        if (describeInstanceTypeOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceTypeOfferingsRequest> request = new DefaultRequest<DescribeInstanceTypeOfferingsRequest>(describeInstanceTypeOfferingsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceTypeOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeInstanceTypeOfferingsRequest.getLocationType() != null) {
            request.addParameter("LocationType", StringUtils.fromString(describeInstanceTypeOfferingsRequest.getLocationType()));
        }
        if (!(describeInstanceTypeOfferingsRequestFiltersList = (SdkInternalList)describeInstanceTypeOfferingsRequest.getFilters()).isEmpty() || !describeInstanceTypeOfferingsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceTypeOfferingsRequestFiltersListValue : describeInstanceTypeOfferingsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceTypeOfferingsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeInstanceTypeOfferingsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceTypeOfferingsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeInstanceTypeOfferingsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceTypeOfferingsRequest.getMaxResults()));
        }
        if (describeInstanceTypeOfferingsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceTypeOfferingsRequest.getNextToken()));
        }
        return request;
    }
}

