/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.IdFormat;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class IdFormatStaxUnmarshaller
implements Unmarshaller<IdFormat, StaxUnmarshallerContext> {
    private static IdFormatStaxUnmarshaller instance;

    @Override
    public IdFormat unmarshall(StaxUnmarshallerContext context) throws Exception {
        IdFormat idFormat = new IdFormat();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return idFormat;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("deadline", targetDepth)) {
                    idFormat.setDeadline(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("resource", targetDepth)) {
                    idFormat.setResource(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("useLongIds", targetDepth)) continue;
                idFormat.setUseLongIds(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return idFormat;
    }

    public static IdFormatStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new IdFormatStaxUnmarshaller();
        }
        return instance;
    }
}

