/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.NetworkCardInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class NetworkCardInfoStaxUnmarshaller
implements Unmarshaller<NetworkCardInfo, StaxUnmarshallerContext> {
    private static NetworkCardInfoStaxUnmarshaller instance;

    @Override
    public NetworkCardInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkCardInfo networkCardInfo = new NetworkCardInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return networkCardInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("networkCardIndex", targetDepth)) {
                    networkCardInfo.setNetworkCardIndex(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkPerformance", targetDepth)) {
                    networkCardInfo.setNetworkPerformance(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("maximumNetworkInterfaces", targetDepth)) continue;
                networkCardInfo.setMaximumNetworkInterfaces(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return networkCardInfo;
    }

    public static NetworkCardInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkCardInfoStaxUnmarshaller();
        }
        return instance;
    }
}

