/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.InstanceCount;
import com.amazonaws.services.ec2.model.PriceSchedule;
import com.amazonaws.services.ec2.model.ReservedInstancesListing;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.InstanceCountStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.PriceScheduleStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ReservedInstancesListingStaxUnmarshaller
implements Unmarshaller<ReservedInstancesListing, StaxUnmarshallerContext> {
    private static ReservedInstancesListingStaxUnmarshaller instance;

    @Override
    public ReservedInstancesListing unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedInstancesListing reservedInstancesListing = new ReservedInstancesListing();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return reservedInstancesListing;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("clientToken", targetDepth)) {
                    reservedInstancesListing.setClientToken(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createDate", targetDepth)) {
                    reservedInstancesListing.setCreateDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceCounts", targetDepth)) {
                    reservedInstancesListing.withInstanceCounts(new ArrayList<InstanceCount>());
                    continue;
                }
                if (context.testExpression("instanceCounts/item", targetDepth)) {
                    reservedInstancesListing.withInstanceCounts(InstanceCountStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("priceSchedules", targetDepth)) {
                    reservedInstancesListing.withPriceSchedules(new ArrayList<PriceSchedule>());
                    continue;
                }
                if (context.testExpression("priceSchedules/item", targetDepth)) {
                    reservedInstancesListing.withPriceSchedules(PriceScheduleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("reservedInstancesId", targetDepth)) {
                    reservedInstancesListing.setReservedInstancesId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("reservedInstancesListingId", targetDepth)) {
                    reservedInstancesListing.setReservedInstancesListingId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("status", targetDepth)) {
                    reservedInstancesListing.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("statusMessage", targetDepth)) {
                    reservedInstancesListing.setStatusMessage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    reservedInstancesListing.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    reservedInstancesListing.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("updateDate", targetDepth)) continue;
                reservedInstancesListing.setUpdateDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return reservedInstancesListing;
    }

    public static ReservedInstancesListingStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ReservedInstancesListingStaxUnmarshaller();
        }
        return instance;
    }
}

