/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SearchTransitGatewayMulticastGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SearchTransitGatewayMulticastGroupsRequestMarshaller
implements Marshaller<Request<SearchTransitGatewayMulticastGroupsRequest>, SearchTransitGatewayMulticastGroupsRequest> {
    @Override
    public Request<SearchTransitGatewayMulticastGroupsRequest> marshall(SearchTransitGatewayMulticastGroupsRequest searchTransitGatewayMulticastGroupsRequest) {
        SdkInternalList searchTransitGatewayMulticastGroupsRequestFiltersList;
        if (searchTransitGatewayMulticastGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SearchTransitGatewayMulticastGroupsRequest> request = new DefaultRequest<SearchTransitGatewayMulticastGroupsRequest>(searchTransitGatewayMulticastGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "SearchTransitGatewayMulticastGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (searchTransitGatewayMulticastGroupsRequest.getTransitGatewayMulticastDomainId() != null) {
            request.addParameter("TransitGatewayMulticastDomainId", StringUtils.fromString(searchTransitGatewayMulticastGroupsRequest.getTransitGatewayMulticastDomainId()));
        }
        if (!(searchTransitGatewayMulticastGroupsRequestFiltersList = (SdkInternalList)searchTransitGatewayMulticastGroupsRequest.getFilters()).isEmpty() || !searchTransitGatewayMulticastGroupsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter searchTransitGatewayMulticastGroupsRequestFiltersListValue : searchTransitGatewayMulticastGroupsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (searchTransitGatewayMulticastGroupsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(searchTransitGatewayMulticastGroupsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)searchTransitGatewayMulticastGroupsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (searchTransitGatewayMulticastGroupsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(searchTransitGatewayMulticastGroupsRequest.getMaxResults()));
        }
        if (searchTransitGatewayMulticastGroupsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(searchTransitGatewayMulticastGroupsRequest.getNextToken()));
        }
        return request;
    }
}

