/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.internal.BlockedOnParentShardException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.AsynchronousGetRecordsRetrievalStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ConsumerStates;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsRetrievalStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisDataFetcher;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.SequenceNumberValidator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownNotification;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.StreamConfig;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.SynchronousGetRecordsRetrievalStrategy;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShardConsumer {
    private static final Log LOG = LogFactory.getLog(ShardConsumer.class);
    private final StreamConfig streamConfig;
    private final IRecordProcessor recordProcessor;
    private final KinesisClientLibConfiguration config;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final ExecutorService executorService;
    private final ShardInfo shardInfo;
    private final KinesisDataFetcher dataFetcher;
    private final IMetricsFactory metricsFactory;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private ICheckpoint checkpoint;
    private final long parentShardPollIntervalMillis;
    private final boolean cleanupLeasesOfCompletedShards;
    private final long taskBackoffTimeMillis;
    private final boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    private final ShardSyncer shardSyncer;
    private ITask currentTask;
    private long currentTaskSubmitTime;
    private Future<TaskResult> future;
    private final GetRecordsCache getRecordsCache;
    private ConsumerStates.ConsumerState currentState = ConsumerStates.INITIAL_STATE;
    private volatile ShutdownReason shutdownReason;
    private volatile ShutdownNotification shutdownNotification;

    private static final GetRecordsRetrievalStrategy makeStrategy(KinesisDataFetcher dataFetcher, Optional<Integer> retryGetRecordsInSeconds, Optional<Integer> maxGetRecordsThreadPool, ShardInfo shardInfo) {
        Optional getRecordsRetrievalStrategy = retryGetRecordsInSeconds.flatMap(retry -> maxGetRecordsThreadPool.map(max -> new AsynchronousGetRecordsRetrievalStrategy(dataFetcher, (int)retry, (int)max, shardInfo.getShardId())));
        return getRecordsRetrievalStrategy.orElse(new SynchronousGetRecordsRetrievalStrategy(dataFetcher));
    }

    ShardConsumer(ShardInfo shardInfo, StreamConfig streamConfig, ICheckpoint checkpoint, IRecordProcessor recordProcessor, ILeaseManager<KinesisClientLease> leaseManager, long parentShardPollIntervalMillis, boolean cleanupLeasesOfCompletedShards, ExecutorService executorService, IMetricsFactory metricsFactory, long backoffTimeMillis, boolean skipShardSyncAtWorkerInitializationIfLeasesExist, KinesisClientLibConfiguration config, ShardSyncer shardSyncer) {
        this(shardInfo, streamConfig, checkpoint, recordProcessor, leaseManager, parentShardPollIntervalMillis, cleanupLeasesOfCompletedShards, executorService, metricsFactory, backoffTimeMillis, skipShardSyncAtWorkerInitializationIfLeasesExist, Optional.empty(), Optional.empty(), config, shardSyncer);
    }

    ShardConsumer(ShardInfo shardInfo, StreamConfig streamConfig, ICheckpoint checkpoint, IRecordProcessor recordProcessor, ILeaseManager<KinesisClientLease> leaseManager, long parentShardPollIntervalMillis, boolean cleanupLeasesOfCompletedShards, ExecutorService executorService, IMetricsFactory metricsFactory, long backoffTimeMillis, boolean skipShardSyncAtWorkerInitializationIfLeasesExist, Optional<Integer> retryGetRecordsInSeconds, Optional<Integer> maxGetRecordsThreadPool, KinesisClientLibConfiguration config, ShardSyncer shardSyncer) {
        this(shardInfo, streamConfig, checkpoint, recordProcessor, new RecordProcessorCheckpointer(shardInfo, checkpoint, new SequenceNumberValidator(streamConfig.getStreamProxy(), shardInfo.getShardId(), streamConfig.shouldValidateSequenceNumberBeforeCheckpointing()), metricsFactory), leaseManager, parentShardPollIntervalMillis, cleanupLeasesOfCompletedShards, executorService, metricsFactory, backoffTimeMillis, skipShardSyncAtWorkerInitializationIfLeasesExist, new KinesisDataFetcher(streamConfig.getStreamProxy(), shardInfo), retryGetRecordsInSeconds, maxGetRecordsThreadPool, config, shardSyncer);
    }

    ShardConsumer(ShardInfo shardInfo, StreamConfig streamConfig, ICheckpoint checkpoint, IRecordProcessor recordProcessor, RecordProcessorCheckpointer recordProcessorCheckpointer, ILeaseManager<KinesisClientLease> leaseManager, long parentShardPollIntervalMillis, boolean cleanupLeasesOfCompletedShards, ExecutorService executorService, IMetricsFactory metricsFactory, long backoffTimeMillis, boolean skipShardSyncAtWorkerInitializationIfLeasesExist, KinesisDataFetcher kinesisDataFetcher, Optional<Integer> retryGetRecordsInSeconds, Optional<Integer> maxGetRecordsThreadPool, KinesisClientLibConfiguration config, ShardSyncer shardSyncer) {
        this.shardInfo = shardInfo;
        this.streamConfig = streamConfig;
        this.checkpoint = checkpoint;
        this.recordProcessor = recordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.leaseManager = leaseManager;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        this.cleanupLeasesOfCompletedShards = cleanupLeasesOfCompletedShards;
        this.executorService = executorService;
        this.metricsFactory = metricsFactory;
        this.taskBackoffTimeMillis = backoffTimeMillis;
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
        this.config = config;
        this.dataFetcher = kinesisDataFetcher;
        this.getRecordsCache = config.getRecordsFetcherFactory().createRecordsFetcher(ShardConsumer.makeStrategy(this.dataFetcher, retryGetRecordsInSeconds, maxGetRecordsThreadPool, this.shardInfo), this.getShardInfo().getShardId(), this.metricsFactory, this.config.getMaxRecords());
        this.shardSyncer = shardSyncer;
    }

    synchronized boolean consumeShard() {
        return this.checkAndSubmitNextTask();
    }

    private boolean readyForNextTask() {
        return this.future == null || this.future.isCancelled() || this.future.isDone();
    }

    private synchronized boolean checkAndSubmitNextTask() {
        boolean submittedNewTask = false;
        if (this.readyForNextTask()) {
            TaskOutcome taskOutcome = TaskOutcome.NOT_COMPLETE;
            if (this.future != null && this.future.isDone()) {
                taskOutcome = this.determineTaskOutcome();
            }
            this.updateState(taskOutcome);
            ITask nextTask = this.getNextTask();
            if (nextTask != null) {
                this.currentTask = nextTask;
                try {
                    this.future = this.executorService.submit(this.currentTask);
                    this.currentTaskSubmitTime = System.currentTimeMillis();
                    submittedNewTask = true;
                    LOG.debug("Submitted new " + (Object)((Object)this.currentTask.getTaskType()) + " task for shard " + this.shardInfo.getShardId());
                }
                catch (RejectedExecutionException e) {
                    LOG.info((Object)((Object)this.currentTask.getTaskType()) + " task was not accepted for execution.", e);
                }
                catch (RuntimeException e) {
                    LOG.info((Object)((Object)this.currentTask.getTaskType()) + " task encountered exception ", e);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("No new task to submit for shard %s, currentState %s", this.shardInfo.getShardId(), this.currentState.toString()));
            }
        } else {
            long timeElapsed = System.currentTimeMillis() - this.currentTaskSubmitTime;
            String commonMessage = String.format("Previous %s task still pending for shard %s since %d ms ago. ", new Object[]{this.currentTask.getTaskType(), this.shardInfo.getShardId(), timeElapsed});
            if (LOG.isDebugEnabled()) {
                LOG.debug(commonMessage + "Not submitting new task.");
            }
            this.config.getLogWarningForTaskAfterMillis().ifPresent(value -> {
                if (timeElapsed > value) {
                    LOG.warn(commonMessage);
                }
            });
        }
        return submittedNewTask;
    }

    public boolean isSkipShardSyncAtWorkerInitializationIfLeasesExist() {
        return this.skipShardSyncAtWorkerInitializationIfLeasesExist;
    }

    private TaskOutcome determineTaskOutcome() {
        try {
            TaskResult result = this.future.get();
            if (result.getException() == null) {
                if (result.isShardEndReached()) {
                    TaskOutcome taskOutcome = TaskOutcome.END_OF_SHARD;
                    return taskOutcome;
                }
                TaskOutcome taskOutcome = TaskOutcome.SUCCESSFUL;
                return taskOutcome;
            }
            this.logTaskException(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.future = null;
        }
        return TaskOutcome.FAILURE;
    }

    private void logTaskException(TaskResult taskResult) {
        if (LOG.isDebugEnabled()) {
            Exception taskException = taskResult.getException();
            if (taskException instanceof BlockedOnParentShardException) {
                LOG.debug("Shard " + this.shardInfo.getShardId() + " is blocked on completion of parent shard.");
            } else {
                LOG.debug("Caught exception running " + (Object)((Object)this.currentTask.getTaskType()) + " task: ", taskResult.getException());
            }
        }
    }

    void notifyShutdownRequested(ShutdownNotification shutdownNotification) {
        this.shutdownNotification = shutdownNotification;
        this.markForShutdown(ShutdownReason.REQUESTED);
    }

    synchronized boolean beginShutdown() {
        this.markForShutdown(ShutdownReason.ZOMBIE);
        this.checkAndSubmitNextTask();
        return this.isShutdown();
    }

    synchronized void markForShutdown(ShutdownReason reason) {
        if (this.shutdownReason == null || this.shutdownReason.canTransitionTo(reason)) {
            this.shutdownReason = reason;
        }
    }

    boolean isShutdown() {
        return this.currentState.isTerminal();
    }

    ShutdownReason getShutdownReason() {
        return this.shutdownReason;
    }

    private ITask getNextTask() {
        ITask nextTask = this.currentState.createTask(this);
        if (nextTask == null) {
            return null;
        }
        return new MetricsCollectingTaskDecorator(nextTask, this.metricsFactory);
    }

    void updateState(TaskOutcome taskOutcome) {
        if (taskOutcome == TaskOutcome.END_OF_SHARD) {
            this.markForShutdown(ShutdownReason.TERMINATE);
        }
        if (this.isShutdownRequested() && taskOutcome != TaskOutcome.FAILURE) {
            this.currentState = this.currentState.shutdownTransition(this.shutdownReason);
        } else if (taskOutcome == TaskOutcome.SUCCESSFUL) {
            if (this.currentState.getTaskType() == this.currentTask.getTaskType()) {
                this.currentState = this.currentState.successTransition();
            } else {
                LOG.error("Current State task type of '" + (Object)((Object)this.currentState.getTaskType()) + "' doesn't match the current tasks type of '" + (Object)((Object)this.currentTask.getTaskType()) + "'.  This shouldn't happen, and indicates a programming error. Unable to safely transition to the next state.");
            }
        }
    }

    @VisibleForTesting
    boolean isShutdownRequested() {
        return this.shutdownReason != null;
    }

    ConsumerStates.ShardConsumerState getCurrentState() {
        return this.currentState.getState();
    }

    StreamConfig getStreamConfig() {
        return this.streamConfig;
    }

    IRecordProcessor getRecordProcessor() {
        return this.recordProcessor;
    }

    RecordProcessorCheckpointer getRecordProcessorCheckpointer() {
        return this.recordProcessorCheckpointer;
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    KinesisDataFetcher getDataFetcher() {
        return this.dataFetcher;
    }

    ILeaseManager<KinesisClientLease> getLeaseManager() {
        return this.leaseManager;
    }

    ICheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    long getParentShardPollIntervalMillis() {
        return this.parentShardPollIntervalMillis;
    }

    boolean isCleanupLeasesOfCompletedShards() {
        return this.cleanupLeasesOfCompletedShards;
    }

    boolean isIgnoreUnexpectedChildShards() {
        return this.config.shouldIgnoreUnexpectedChildShards();
    }

    long getTaskBackoffTimeMillis() {
        return this.taskBackoffTimeMillis;
    }

    Future<TaskResult> getFuture() {
        return this.future;
    }

    ShutdownNotification getShutdownNotification() {
        return this.shutdownNotification;
    }

    public ShardSyncer getShardSyncer() {
        return this.shardSyncer;
    }

    public GetRecordsCache getGetRecordsCache() {
        return this.getRecordsCache;
    }

    private static enum TaskOutcome {
        SUCCESSFUL,
        END_OF_SHARD,
        NOT_COMPLETE,
        FAILURE;

    }
}

