/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import com.amazonaws.services.sqs.buffered.QueueBufferCallback;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.amazonaws.services.sqs.buffered.QueueBufferFuture;
import com.amazonaws.services.sqs.buffered.ResultConverter;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.QueueAttributeName;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReceiveQueueBuffer {
    private static Log log = LogFactory.getLog(ReceiveQueueBuffer.class);
    private final QueueBufferConfig config;
    private final String qUrl;
    private final Executor executor;
    private final ScheduledExecutorService waitTimer = Executors.newSingleThreadScheduledExecutor();
    private final AmazonSQS sqsClient;
    private long bufferCounter = 0L;
    private volatile long visibilityTimeoutNanos = -1L;
    private volatile int defaultWaitTimeSeconds = -1;
    private volatile int inflightReceiveMessageBatches;
    private final Object taskSpawnSyncPoint = new Object();
    volatile boolean shutDown = false;
    private final Set<ReceiveMessageFuture> futures = new LinkedHashSet<ReceiveMessageFuture>();
    private LinkedList<ReceiveMessageBatchTask> finishedTasks = new LinkedList();

    ReceiveQueueBuffer(AmazonSQS paramSQS, Executor paramExecutor, QueueBufferConfig paramConfig, String url) {
        this.config = paramConfig;
        this.executor = paramExecutor;
        this.sqsClient = paramSQS;
        this.qUrl = url;
    }

    public void shutdown() {
        this.shutDown = true;
        try {
            while (this.inflightReceiveMessageBatches > 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.waitTimer.shutdown();
        try {
            this.waitTimer.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResult> receiveMessageAsync(ReceiveMessageRequest rq, QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> callback) {
        if (this.shutDown) {
            throw new AmazonClientException("The client has been shut down.");
        }
        int numMessages = 10;
        if (rq.getMaxNumberOfMessages() != null) {
            numMessages = rq.getMaxNumberOfMessages();
        }
        Set<ReceiveMessageFuture> set = this.futures;
        synchronized (set) {
            if (this.defaultWaitTimeSeconds == -1) {
                GetQueueAttributesRequest request = new GetQueueAttributesRequest().withQueueUrl(this.qUrl).withAttributeNames(QueueAttributeName.ReceiveMessageWaitTimeSeconds);
                ResultConverter.appendUserAgent(request, AmazonSQSBufferedAsyncClient.USER_AGENT);
                this.defaultWaitTimeSeconds = Integer.parseInt(this.sqsClient.getQueueAttributes(request).getAttributes().get(QueueAttributeName.ReceiveMessageWaitTimeSeconds.toString()));
            }
        }
        int waitTimeSeconds = this.defaultWaitTimeSeconds;
        if (rq.getWaitTimeSeconds() != null) {
            waitTimeSeconds = rq.getWaitTimeSeconds();
        }
        long waitTimeMs = Math.max((long)this.config.getMinReceiveWaitTimeMs(), TimeUnit.MILLISECONDS.convert(waitTimeSeconds, TimeUnit.SECONDS));
        ReceiveMessageFuture toReturn = this.issueFuture(numMessages, waitTimeMs, callback);
        this.satisfyFuturesFromBuffer();
        this.spawnMoreReceiveTasks();
        toReturn.startWaitTimer();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveMessageFuture issueFuture(int size, long waitTimeMs, QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> callback) {
        Set<ReceiveMessageFuture> set = this.futures;
        synchronized (set) {
            ReceiveMessageFuture theFuture = new ReceiveMessageFuture(callback, size, waitTimeMs);
            this.futures.add(theFuture);
            return theFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void satisfyFuturesFromBuffer() {
        Set<ReceiveMessageFuture> set = this.futures;
        synchronized (set) {
            LinkedList<ReceiveMessageBatchTask> linkedList = this.finishedTasks;
            synchronized (linkedList) {
                Iterator<ReceiveMessageFuture> futureIter = this.futures.iterator();
                while (futureIter.hasNext() && !this.finishedTasks.isEmpty()) {
                    this.pruneExpiredTasks();
                    if (this.finishedTasks.isEmpty()) continue;
                    this.fufillFuture(futureIter.next());
                    futureIter.remove();
                }
            }
        }
    }

    private void fufillFuture(ReceiveMessageFuture future) {
        ReceiveMessageBatchTask task = this.finishedTasks.getFirst();
        ReceiveMessageResult result = new ReceiveMessageResult();
        LinkedList<Message> messages = new LinkedList<Message>();
        result.setMessages(messages);
        Exception exception = task.getException();
        boolean batchDone = false;
        for (int numRetrieved = 0; numRetrieved < future.getRequestedSize(); ++numRetrieved) {
            Message msg = task.removeMessage();
            if (msg != null) {
                messages.add(msg);
                continue;
            }
            batchDone = true;
            break;
        }
        boolean bl = batchDone = batchDone || task.isEmpty() || exception != null;
        if (batchDone) {
            this.finishedTasks.removeFirst();
        }
        result.setMessages(messages);
        if (exception != null) {
            future.setFailure(exception);
        } else {
            future.setSuccess(result);
        }
    }

    private void pruneExpiredTasks() {
        int numberExpiredTasksPruned = this.pruneHeadTasks(new Predicate<ReceiveMessageBatchTask>(){

            @Override
            public boolean test(ReceiveMessageBatchTask t) {
                return t.isExpired() && t.getException() == null;
            }
        });
        if (numberExpiredTasksPruned > 0) {
            this.pruneHeadTasks(new Predicate<ReceiveMessageBatchTask>(){

                @Override
                public boolean test(ReceiveMessageBatchTask t) {
                    return t.isEmpty() && t.getException() == null;
                }
            });
        }
    }

    private int pruneHeadTasks(Predicate<ReceiveMessageBatchTask> pruneCondition) {
        int numberPruned = 0;
        while (!this.finishedTasks.isEmpty() && pruneCondition.test(this.finishedTasks.getFirst())) {
            this.finishedTasks.removeFirst();
            ++numberPruned;
        }
        return numberPruned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnMoreReceiveTasks() {
        Object object;
        if (this.shutDown) {
            return;
        }
        int desiredBatches = this.config.getMaxDoneReceiveBatches();
        int n = desiredBatches = desiredBatches < 1 ? 1 : desiredBatches;
        if (this.config.isAdapativePrefetching()) {
            object = this.futures;
            synchronized (object) {
                int totalRequested = 0;
                for (ReceiveMessageFuture future : this.futures) {
                    totalRequested += future.getRequestedSize();
                }
                int batchesNeededToFulfillFutures = (int)Math.ceil((float)totalRequested / (float)this.config.getMaxBatchSize());
                desiredBatches = Math.min(batchesNeededToFulfillFutures, desiredBatches);
            }
        }
        object = this.finishedTasks;
        synchronized (object) {
            if (this.finishedTasks.size() >= desiredBatches) {
                return;
            }
            if (this.finishedTasks.size() > 0 && this.finishedTasks.size() + this.inflightReceiveMessageBatches >= desiredBatches) {
                return;
            }
        }
        object = this.taskSpawnSyncPoint;
        synchronized (object) {
            int max;
            int toSpawn;
            if (this.visibilityTimeoutNanos == -1L) {
                GetQueueAttributesRequest request = new GetQueueAttributesRequest().withQueueUrl(this.qUrl).withAttributeNames("VisibilityTimeout");
                ResultConverter.appendUserAgent(request, AmazonSQSBufferedAsyncClient.USER_AGENT);
                long visibilityTimeoutSeconds = Long.parseLong(this.sqsClient.getQueueAttributes(request).getAttributes().get("VisibilityTimeout"));
                this.visibilityTimeoutNanos = TimeUnit.NANOSECONDS.convert(visibilityTimeoutSeconds, TimeUnit.SECONDS);
            }
            if ((toSpawn = (max = (max = this.config.getMaxInflightReceiveBatches()) > 0 ? max : 1) - this.inflightReceiveMessageBatches) > 0) {
                ReceiveMessageBatchTask task = new ReceiveMessageBatchTask(this);
                ++this.inflightReceiveMessageBatches;
                ++this.bufferCounter;
                if (log.isTraceEnabled()) {
                    log.trace("Spawned receive batch #" + this.bufferCounter + " (" + this.inflightReceiveMessageBatches + " of " + max + " inflight) for queue " + this.qUrl);
                }
                this.executor.execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBatchFinished(ReceiveMessageBatchTask batch) {
        Object object = this.finishedTasks;
        synchronized (object) {
            this.finishedTasks.addLast(batch);
            if (log.isTraceEnabled()) {
                log.trace("Queue " + this.qUrl + " now has " + this.finishedTasks.size() + " receive results cached ");
            }
        }
        object = this.taskSpawnSyncPoint;
        synchronized (object) {
            --this.inflightReceiveMessageBatches;
        }
        this.satisfyFuturesFromBuffer();
        this.spawnMoreReceiveTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean done = false;
        while (!done) {
            ReceiveMessageBatchTask currentBatch = null;
            LinkedList<ReceiveMessageBatchTask> linkedList = this.finishedTasks;
            synchronized (linkedList) {
                currentBatch = this.finishedTasks.poll();
            }
            if (currentBatch != null) {
                currentBatch.clear();
                continue;
            }
            done = true;
        }
    }

    private class ReceiveMessageBatchTask
    implements Runnable {
        private Exception exception = null;
        private List<Message> messages;
        private long visibilityDeadlineNano;
        private boolean open = false;
        private ReceiveQueueBuffer parentBuffer;

        ReceiveMessageBatchTask(ReceiveQueueBuffer paramParentBuffer) {
            this.parentBuffer = paramParentBuffer;
            this.messages = Collections.emptyList();
        }

        synchronized boolean isEmpty() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            return this.messages.isEmpty();
        }

        synchronized Exception getException() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            return this.exception;
        }

        synchronized Message removeMessage() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            if (this.isExpired()) {
                this.messages.clear();
                return null;
            }
            if (this.messages.isEmpty()) {
                return null;
            }
            return this.messages.remove(this.messages.size() - 1);
        }

        boolean isExpired() {
            return System.nanoTime() > this.visibilityDeadlineNano;
        }

        synchronized void clear() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            if (!this.isExpired()) {
                ChangeMessageVisibilityBatchRequest batchRequest = new ChangeMessageVisibilityBatchRequest().withQueueUrl(ReceiveQueueBuffer.this.qUrl);
                ResultConverter.appendUserAgent(batchRequest, AmazonSQSBufferedAsyncClient.USER_AGENT);
                ArrayList<ChangeMessageVisibilityBatchRequestEntry> entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(this.messages.size());
                int i = 0;
                for (Message m3 : this.messages) {
                    entries.add(new ChangeMessageVisibilityBatchRequestEntry().withId(Integer.toString(i)).withReceiptHandle(m3.getReceiptHandle()).withVisibilityTimeout(0));
                    ++i;
                }
                try {
                    batchRequest.setEntries(entries);
                    ReceiveQueueBuffer.this.sqsClient.changeMessageVisibilityBatch(batchRequest);
                }
                catch (AmazonClientException e) {
                    log.warn("ReceiveMessageBatchTask: changeMessageVisibility failed " + e);
                }
            }
            this.messages.clear();
        }

        @Override
        public void run() {
            try {
                this.visibilityDeadlineNano = System.nanoTime() + ReceiveQueueBuffer.this.visibilityTimeoutNanos;
                ReceiveMessageRequest request = new ReceiveMessageRequest(ReceiveQueueBuffer.this.qUrl).withMaxNumberOfMessages(ReceiveQueueBuffer.this.config.getMaxBatchSize()).withMessageAttributeNames(ReceiveQueueBuffer.this.config.getReceiveMessageAttributeNames()).withAttributeNames(ReceiveQueueBuffer.this.config.getReceiveAttributeNames());
                ResultConverter.appendUserAgent(request, AmazonSQSBufferedAsyncClient.USER_AGENT);
                if (ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds() > 0) {
                    request.setVisibilityTimeout(ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds());
                    this.visibilityDeadlineNano = System.nanoTime() + TimeUnit.NANOSECONDS.convert(ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds(), TimeUnit.SECONDS);
                }
                if (ReceiveQueueBuffer.this.config.isLongPoll()) {
                    request.withWaitTimeSeconds(ReceiveQueueBuffer.this.config.getLongPollWaitTimeoutSeconds());
                }
                this.messages = ReceiveQueueBuffer.this.sqsClient.receiveMessage(request).getMessages();
            }
            catch (AmazonClientException e) {
                this.exception = e;
            }
            finally {
                this.open = true;
                this.parentBuffer.reportBatchFinished(this);
            }
        }
    }

    private class ReceiveMessageFuture
    extends QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResult> {
        private int requestedSize;
        private final long waitTimeDeadlineNano;
        private volatile Future<?> timeoutFuture;

        ReceiveMessageFuture(QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResult> cb, int paramSize, long waitTimeMs) {
            super(cb);
            this.requestedSize = paramSize;
            this.waitTimeDeadlineNano = System.nanoTime() + TimeUnit.NANOSECONDS.convert(waitTimeMs, TimeUnit.MILLISECONDS);
        }

        public void startWaitTimer() {
            if (this.isDone() || this.timeoutFuture != null) {
                return;
            }
            long remaining = this.waitTimeDeadlineNano - System.nanoTime();
            if (remaining <= 0L) {
                this.timeout();
            } else {
                Runnable timeoutRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ReceiveMessageFuture.this.timeout();
                    }
                };
                this.timeoutFuture = ReceiveQueueBuffer.this.waitTimer.schedule(timeoutRunnable, remaining, TimeUnit.NANOSECONDS);
            }
        }

        public boolean isExpired() {
            return System.nanoTime() > this.waitTimeDeadlineNano;
        }

        @Override
        public synchronized void setSuccess(ReceiveMessageResult result) {
            this.cancelTimeout();
            super.setSuccess(result);
        }

        @Override
        public synchronized void setFailure(Exception exception) {
            this.cancelTimeout();
            super.setFailure(exception);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void timeout() {
            Set set = ReceiveQueueBuffer.this.futures;
            synchronized (set) {
                ReceiveMessageFuture receiveMessageFuture = this;
                synchronized (receiveMessageFuture) {
                    if (!this.isDone()) {
                        this.setSuccess(new ReceiveMessageResult());
                        ReceiveQueueBuffer.this.futures.remove(this);
                    }
                }
            }
        }

        public int getRequestedSize() {
            return this.requestedSize;
        }

        private synchronized void cancelTimeout() {
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
        }
    }

    private static interface Predicate<T> {
        public boolean test(T var1);
    }
}

