/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.inputs.cloudtrail;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.assistedinject.Assisted;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.aws.AWSObjectMapper;
import org.graylog.aws.inputs.cloudtrail.json.CloudTrailRecord;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTime;

public class CloudTrailCodec
extends AbstractCodec {
    public static final String NAME = "AWSCloudTrail";
    private final ObjectMapper objectMapper;

    @Inject
    public CloudTrailCodec(@Assisted Configuration configuration, @AWSObjectMapper ObjectMapper objectMapper) {
        super(configuration);
        this.objectMapper = objectMapper;
    }

    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        try {
            CloudTrailRecord record = (CloudTrailRecord)this.objectMapper.readValue(rawMessage.getPayload(), CloudTrailRecord.class);
            String source = this.configuration.getString("override_source", "aws-cloudtrail");
            Message message = new Message(record.getConstructedMessage(), source, DateTime.parse((String)record.eventTime));
            message.addFields(record.additionalFieldsAsMap());
            message.addField("full_message", (Object)record.getFullMessage());
            message.addField("aws_source", (Object)true);
            return message;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize CloudTrail record.", e);
        }
    }

    public String getName() {
        return NAME;
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<CloudTrailCodec> {
        public CloudTrailCodec create(Configuration var1);

        public Config getConfig();
    }
}

