/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc;

import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.HashOrderMixing;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.ObjectObjectHashMap;

public class ObjectObjectScatterMap<KType, VType>
extends ObjectObjectHashMap<KType, VType> {
    public ObjectObjectScatterMap() {
        this(4);
    }

    public ObjectObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType, VType> ObjectObjectScatterMap<KType, VType> from(KType[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectScatterMap<KType, VType> map = new ObjectObjectScatterMap<KType, VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

